/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.ArrayList;
import java.util.List;

public class LazyList<T> {
    private List<T> internalList = new ArrayList<T>();
    private List<T> list = this.internalList;
    private boolean needsCopy = false;

    public void copyList(List<T> list) {
        this.list = list;
        this.needsCopy = true;
    }

    public void add(T object) {
        this.resolve();
        this.list.add(object);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void clear() {
        this.needsCopy = false;
        this.list = this.internalList;
        this.list.clear();
    }

    public List<T> getList() {
        return this.list;
    }

    public List<T> extractList() {
        if (this.needsCopy) {
            ArrayList<T> extracted = new ArrayList<T>(this.list);
            this.clear();
            return extracted;
        }
        List<T> extracted = this.internalList;
        this.internalList = new ArrayList<T>();
        return extracted;
    }

    private void resolve() {
        if (this.needsCopy) {
            this.needsCopy = false;
            this.list = new ArrayList<T>(this.list);
        }
    }
}

