/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;

public class InventorySlotSyncPacket
implements IThreadsafePacket {
    public final ItemStack itemStack;
    public final int slot;
    public final BlockPos pos;

    public InventorySlotSyncPacket(ItemStack itemStack, int slot, BlockPos pos) {
        this.itemStack = itemStack;
        this.slot = slot;
        this.pos = pos;
    }

    public InventorySlotSyncPacket(FriendlyByteBuf buffer) {
        this.itemStack = buffer.m_130267_();
        this.slot = buffer.readShort();
        this.pos = buffer.m_130135_();
    }

    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130055_(this.itemStack);
        packetBuffer.writeShort(this.slot);
        packetBuffer.m_130064_(this.pos);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(InventorySlotSyncPacket packet) {
            BlockEntity te;
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world != null && (te = world.m_7702_(packet.pos)) != null) {
                te.getCapability(ForgeCapabilities.ITEM_HANDLER).filter(cap -> cap instanceof IItemHandlerModifiable).ifPresent(cap -> {
                    ((IItemHandlerModifiable)cap).setStackInSlot(packet.slot, packet.itemStack);
                    Minecraft.m_91087_().f_91060_.m_109544_(null, packet.pos, null, null, 0);
                });
            }
        }
    }
}

