/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.data.material;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.library.client.data.spritetransformer.IColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.client.data.spritetransformer.RecolorSpriteTransformer;
import slimeknights.tconstruct.library.client.materials.MaterialGeneratorInfo;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.tools.data.sprite.TinkerPartSpriteProvider;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;
import slimeknights.tconstruct.tools.stats.PlatingMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public abstract class AbstractMaterialSpriteProvider {
    private final Map<ResourceLocation, MaterialSpriteInfoBuilder> materialBuilders = new HashMap<ResourceLocation, MaterialSpriteInfoBuilder>();
    private Map<ResourceLocation, MaterialSpriteInfo> builtMaterials = null;

    public abstract String getName();

    protected abstract void addAllMaterials();

    public Map<ResourceLocation, MaterialSpriteInfo> getMaterials() {
        if (this.builtMaterials == null) {
            this.addAllMaterials();
            this.builtMaterials = this.materialBuilders.values().stream().map(MaterialSpriteInfoBuilder::build).collect(Collectors.toMap(MaterialSpriteInfo::getTexture, Function.identity()));
            this.materialBuilders.clear();
        }
        return this.builtMaterials;
    }

    @Nullable
    public MaterialSpriteInfo getMaterialInfo(ResourceLocation name) {
        return this.getMaterials().get(name);
    }

    protected MaterialSpriteInfoBuilder buildMaterial(ResourceLocation name) {
        if (this.builtMaterials != null) {
            throw new IllegalStateException("Attempted to add a material when materials already built");
        }
        return this.materialBuilders.computeIfAbsent(name, MaterialSpriteInfoBuilder::new);
    }

    protected MaterialSpriteInfoBuilder buildMaterial(MaterialId name) {
        return this.buildMaterial((ResourceLocation)name);
    }

    protected MaterialSpriteInfoBuilder buildMaterial(MaterialVariantId name) {
        return this.buildMaterial(name.getLocation('_'));
    }

    public static class MaterialSpriteInfo
    extends MaterialGeneratorInfo {
        private final transient ResourceLocation texture;
        private final transient String[] fallbacks;

        public MaterialSpriteInfo(ResourceLocation texture, String[] fallbacks, MaterialGeneratorInfo generatorJson) {
            super(generatorJson);
            this.texture = texture;
            this.fallbacks = fallbacks;
        }

        public MaterialSpriteInfo(ResourceLocation texture, String[] fallbacks, ISpriteTransformer transformer, Set<MaterialStatsId> supportedStats, boolean variant) {
            super(transformer, supportedStats, false, variant);
            this.texture = texture;
            this.fallbacks = fallbacks;
        }

        @Override
        public boolean supportStatType(MaterialStatsId statType) {
            if (super.supportStatType(statType)) {
                return true;
            }
            if (!this.ignoreMaterialStats && MaterialRegistry.isFullyLoaded()) {
                return MaterialRegistry.getInstance().getMaterialStats(new MaterialId(this.texture), statType).isPresent();
            }
            return false;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public String[] getFallbacks() {
            return this.fallbacks;
        }
    }

    @CanIgnoreReturnValue
    protected static class MaterialSpriteInfoBuilder {
        private static final String[] EMPTY_STRING_ARRAY = new String[0];
        private final ResourceLocation texture;
        private String[] fallbacks = EMPTY_STRING_ARRAY;
        private final ImmutableSet.Builder<MaterialStatsId> statTypes = ImmutableSet.builder();
        @Nullable
        private ISpriteTransformer transformer;
        private boolean variant = false;

        public MaterialSpriteInfoBuilder fallbacks(String ... fallbacks) {
            this.fallbacks = fallbacks;
            return this;
        }

        public MaterialSpriteInfoBuilder colorMapper(IColorMapping mapping) {
            return this.transformer(new RecolorSpriteTransformer(mapping));
        }

        public MaterialSpriteInfoBuilder variant() {
            return this.variant(true);
        }

        public MaterialSpriteInfoBuilder statType(MaterialStatsId statsId) {
            this.statTypes.add((Object)statsId);
            return this;
        }

        public MaterialSpriteInfoBuilder statType(MaterialStatsId ... statsId) {
            this.statTypes.add((Object[])statsId);
            return this;
        }

        public MaterialSpriteInfoBuilder repairKit() {
            return this.statType(StatlessMaterialStats.REPAIR_KIT.getIdentifier());
        }

        public MaterialSpriteInfoBuilder meleeHarvest() {
            this.statType(HeadMaterialStats.ID);
            this.statType(HandleMaterialStats.ID);
            this.statType(StatlessMaterialStats.BINDING.getIdentifier());
            this.repairKit();
            return this;
        }

        public MaterialSpriteInfoBuilder ranged() {
            this.statType(LimbMaterialStats.ID);
            this.statType(GripMaterialStats.ID);
            this.repairKit();
            return this;
        }

        public MaterialSpriteInfoBuilder maille() {
            this.statType(StatlessMaterialStats.MAILLE.getIdentifier());
            this.statType(TinkerPartSpriteProvider.ARMOR_MAILLE);
            return this;
        }

        public MaterialSpriteInfoBuilder plating() {
            this.statType(TinkerPartSpriteProvider.ARMOR_PLATING);
            for (MaterialStatType<PlatingMaterialStats> type : PlatingMaterialStats.TYPES) {
                this.statType(type.getId());
            }
            this.repairKit();
            return this;
        }

        public MaterialSpriteInfoBuilder armor() {
            this.plating();
            this.maille();
            return this;
        }

        public MaterialSpriteInfoBuilder shieldCore() {
            return this.statType(StatlessMaterialStats.SHIELD_CORE.getIdentifier());
        }

        @CheckReturnValue
        private MaterialSpriteInfo build() {
            if (this.transformer == null) {
                throw new IllegalStateException("Material must have a transformer for a sprite provider");
            }
            ImmutableSet supportedStats = this.statTypes.build();
            if (supportedStats.isEmpty()) {
                throw new IllegalStateException("Material must support at least one stat type");
            }
            return new MaterialSpriteInfo(this.texture, this.fallbacks, this.transformer, (Set<MaterialStatsId>)supportedStats, this.variant);
        }

        private MaterialSpriteInfoBuilder(ResourceLocation texture) {
            this.texture = texture;
        }

        public MaterialSpriteInfoBuilder transformer(@Nullable ISpriteTransformer transformer) {
            this.transformer = transformer;
            return this;
        }

        public MaterialSpriteInfoBuilder variant(boolean variant) {
            this.variant = variant;
            return this;
        }
    }
}

