/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.math;

import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.floats.FloatStack;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.tconstruct.library.json.math.PostFixOperator;
import slimeknights.tconstruct.library.json.math.PushConstantOperation;
import slimeknights.tconstruct.library.json.math.PushVariableOperation;

public interface StackOperation {
    public void perform(FloatStack var1, float[] var2);

    public JsonPrimitive serialize(String[] var1);

    public static StackOperation deserialize(JsonPrimitive element, String[] variableNames) {
        if (element.isString()) {
            String str = element.getAsString();
            if (str.isBlank()) {
                throw new JsonSyntaxException("Operation must not be empty");
            }
            if (str.charAt(0) == '$') {
                str = str.substring(1);
                for (int i = 0; i < variableNames.length; ++i) {
                    if (!str.equals(variableNames[i])) continue;
                    return new PushVariableOperation(i);
                }
                throw new JsonSyntaxException("Unknown variable '" + str + "'");
            }
            return PostFixOperator.deserialize(str);
        }
        if (element.isNumber()) {
            return new PushConstantOperation(element.getAsFloat());
        }
        throw new JsonSyntaxException("Expected stack operation to be a string or number, got boolean");
    }

    public void toNetwork(FriendlyByteBuf var1);

    public static StackOperation fromNetwork(FriendlyByteBuf buffer) {
        int type = buffer.m_130242_();
        if (type == PostFixOperator.VALUE_INDEX) {
            return new PushConstantOperation(buffer.readFloat());
        }
        if (type == PostFixOperator.VARIABLE_INDEX) {
            return new PushVariableOperation(buffer.m_130242_());
        }
        return PostFixOperator.values()[type];
    }
}

