/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;

public abstract class FluidEffectContext {
    protected final Level level;
    @Nullable
    protected final LivingEntity entity;
    @Nullable
    protected final Player player;
    @Nullable
    protected final Projectile projectile;
    protected final ItemStack stack;

    @Deprecated
    public FluidEffectContext(Level level, @Nullable LivingEntity entity, @Nullable Player player, @Nullable Projectile projectile) {
        this(level, entity, player, projectile, ItemStack.f_41583_);
    }

    public abstract BlockPos getBlockPos();

    public abstract Vec3 getLocation();

    public DamageSource createDamageSource() {
        if (this.projectile != null) {
            return this.projectile.m_269291_().m_269299_((net.minecraft.world.entity.Entity)this.projectile, this.entity);
        }
        if (this.player != null) {
            return this.player.m_269291_().m_269075_(this.player);
        }
        if (this.entity != null) {
            return this.entity.m_269291_().m_269333_(this.entity);
        }
        return this.level.m_269111_().m_269264_();
    }

    public static Builder builder(Level level) {
        return new Builder(level);
    }

    public Level getLevel() {
        return this.level;
    }

    @Nullable
    public LivingEntity getEntity() {
        return this.entity;
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    @Nullable
    public Projectile getProjectile() {
        return this.projectile;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public FluidEffectContext(Level level, @Nullable LivingEntity entity, @Nullable Player player, @Nullable Projectile projectile, ItemStack stack) {
        this.level = level;
        this.entity = entity;
        this.player = player;
        this.projectile = projectile;
        this.stack = stack;
    }

    @CanIgnoreReturnValue
    public static class Builder {
        private final Level level;
        private LivingEntity entity = null;
        private Player player = null;
        private Projectile projectile = null;
        private ItemStack stack = ItemStack.f_41583_;
        private Vec3 location = null;

        public Builder user(@Nullable LivingEntity entity, @Nullable Player player) {
            this.entity = entity;
            this.player = player;
            return this;
        }

        public Builder user(@Nullable net.minecraft.world.entity.Entity entity) {
            return this.user(ModifierUtil.asLiving(entity));
        }

        public Builder user(@Nullable LivingEntity entity) {
            if (entity != null) {
                this.user(entity, ModifierUtil.asPlayer((net.minecraft.world.entity.Entity)entity));
            }
            return this;
        }

        public Builder user(@Nullable Player player) {
            return this.user((LivingEntity)player, player);
        }

        public Block block(BlockHitResult hitResult) {
            return new Block(this.level, this.entity, this.player, this.projectile, this.stack, hitResult);
        }

        public Entity target(net.minecraft.world.entity.Entity target, @Nullable LivingEntity livingTarget) {
            return new Entity(this.level, this.entity, this.player, this.projectile, this.stack, target, livingTarget, this.location);
        }

        public Entity target(net.minecraft.world.entity.Entity target) {
            return this.target(target, ModifierUtil.asLiving(target));
        }

        public Entity target(LivingEntity target) {
            return this.target((net.minecraft.world.entity.Entity)target, target);
        }

        private Builder(Level level) {
            this.level = level;
        }

        public Builder projectile(Projectile projectile) {
            this.projectile = projectile;
            return this;
        }

        public Builder stack(ItemStack stack) {
            this.stack = stack;
            return this;
        }

        public Builder location(Vec3 location) {
            this.location = location;
            return this;
        }
    }

    public static class Block
    extends FluidEffectContext {
        private final BlockHitResult hitResult;
        private BlockState state;

        private Block(Level level, @Nullable LivingEntity holder, @Nullable Player player, @Nullable Projectile projectile, ItemStack stack, BlockHitResult hitResult) {
            super(level, holder, player, projectile, stack);
            this.hitResult = hitResult;
        }

        @Deprecated(forRemoval=true)
        public Block(Level level, @Nullable LivingEntity holder, @Nullable Player player, @Nullable Projectile projectile, BlockHitResult hitResult) {
            this(level, holder, player, projectile, ItemStack.f_41583_, hitResult);
        }

        @Deprecated(forRemoval=true)
        public Block(Level level, @Nullable LivingEntity holder, @Nullable Projectile projectile, BlockHitResult hitResult) {
            this(level, holder, ModifierUtil.asPlayer((net.minecraft.world.entity.Entity)holder), projectile, hitResult);
        }

        @Deprecated(forRemoval=true)
        public Block(Level level, @Nullable Player player, @Nullable Projectile projectile, BlockHitResult hitResult) {
            this(level, (LivingEntity)player, player, projectile, hitResult);
        }

        @Override
        public BlockPos getBlockPos() {
            return this.hitResult.m_82425_();
        }

        @Override
        public Vec3 getLocation() {
            return this.hitResult.m_82450_();
        }

        public Block withHitResult(BlockHitResult result) {
            return new Block(this.level, this.entity, this.player, this.projectile, this.stack, result);
        }

        public BlockState getBlockState() {
            if (this.state == null) {
                this.state = this.level.m_8055_(this.hitResult.m_82425_());
            }
            return this.state;
        }

        public boolean isOffsetReplaceable() {
            return this.level.m_8055_(this.hitResult.m_82425_().m_121945_(this.hitResult.m_82434_())).m_247087_();
        }

        public BlockHitResult getHitResult() {
            return this.hitResult;
        }
    }

    public static class Entity
    extends FluidEffectContext {
        private final net.minecraft.world.entity.Entity target;
        @Nullable
        private final LivingEntity livingTarget;
        private final Vec3 location;

        private Entity(Level level, @Nullable LivingEntity holder, @Nullable Player player, @Nullable Projectile projectile, ItemStack stack, net.minecraft.world.entity.Entity target, @Nullable LivingEntity livingTarget, @Nullable Vec3 location) {
            super(level, holder, player, projectile, stack);
            this.target = target;
            this.livingTarget = livingTarget;
            this.location = Objects.requireNonNullElse(location, target.m_20182_());
        }

        @Deprecated(forRemoval=true)
        public Entity(Level level, @Nullable LivingEntity holder, @Nullable Player player, @Nullable Projectile projectile, net.minecraft.world.entity.Entity target, @Nullable LivingEntity livingTarget, @Nullable Vec3 location) {
            this(level, holder, player, projectile, ItemStack.f_41583_, target, livingTarget, location);
        }

        @Deprecated(forRemoval=true)
        public Entity(Level level, @Nullable LivingEntity holder, @Nullable Player player, @Nullable Projectile projectile, net.minecraft.world.entity.Entity target, @Nullable LivingEntity livingTarget) {
            this(level, holder, player, projectile, target, livingTarget, null);
        }

        @Deprecated(forRemoval=true)
        public Entity(Level level, @Nullable LivingEntity holder, @Nullable Projectile projectile, net.minecraft.world.entity.Entity target, @Nullable Vec3 location) {
            this(level, holder, ModifierUtil.asPlayer((net.minecraft.world.entity.Entity)holder), projectile, target, ModifierUtil.asLiving(target), location);
        }

        @Deprecated(forRemoval=true)
        public Entity(Level level, Player player, @Nullable Projectile projectile, LivingEntity target) {
            this(level, (LivingEntity)player, player, projectile, (net.minecraft.world.entity.Entity)target, target);
        }

        @Override
        public BlockPos getBlockPos() {
            return this.target.m_20183_();
        }

        public net.minecraft.world.entity.Entity getTarget() {
            return this.target;
        }

        @Nullable
        public LivingEntity getLivingTarget() {
            return this.livingTarget;
        }

        @Override
        public Vec3 getLocation() {
            return this.location;
        }
    }
}

