/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.material;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;

public class MaterialRecipeCache {
    private static final List<MaterialRecipe> RECIPES = new ArrayList<MaterialRecipe>();
    private static final Map<Item, MaterialRecipe> RECIPE_BY_ITEM = new ConcurrentHashMap<Item, MaterialRecipe>();
    private static final Multimap<MaterialVariantId, MaterialRecipe> RECIPES_BY_MATERIAL = HashMultimap.create();
    private static final Map<MaterialVariantId, List<ItemStack>> ITEMS_BY_MATERIAL = new ConcurrentHashMap<MaterialVariantId, List<ItemStack>>();
    private static final Multimap<MaterialId, MaterialVariantId> KNOWN_VARIANTS = HashMultimap.create();
    @Nullable
    private static List<MaterialVariantId> SORTED_VARIANTS = null;
    private static final RecipeCacheInvalidator.DuelSidedListener LISTENER = RecipeCacheInvalidator.addDuelSidedListener(() -> {
        RECIPES.clear();
        RECIPE_BY_ITEM.clear();
        KNOWN_VARIANTS.clear();
        SORTED_VARIANTS = null;
    });
    private static final Function<MaterialVariantId, List<ItemStack>> GET_ITEMS_BY_MATERIAL = variant -> MaterialRecipeCache.getRecipes(variant).stream().flatMap(r -> Arrays.stream(r.getIngredient().m_43908_())).toList();

    public static void registerRecipe(MaterialRecipe recipe) {
        if (recipe.getValue() > 0) {
            LISTENER.checkClear();
            RECIPES.add(recipe);
            MaterialVariantId variant = recipe.getMaterial().getVariant();
            MaterialRecipeCache.addKnownVariant(variant);
            RECIPES_BY_MATERIAL.put((Object)variant, (Object)recipe);
        }
    }

    public static MaterialRecipe findRecipe(ItemStack stack) {
        if (stack.m_41619_()) {
            return MaterialRecipe.EMPTY;
        }
        return RECIPE_BY_ITEM.computeIfAbsent(stack.m_41720_(), item -> {
            for (MaterialRecipe recipe : RECIPES) {
                if (!recipe.getIngredient().test(stack)) continue;
                return recipe;
            }
            return MaterialRecipe.EMPTY;
        });
    }

    public static Collection<MaterialRecipe> getAllRecipes() {
        return RECIPES;
    }

    public static Collection<MaterialRecipe> getRecipes(MaterialVariantId variant) {
        return RECIPES_BY_MATERIAL.get((Object)variant);
    }

    public static List<ItemStack> getItems(MaterialVariantId variant) {
        return ITEMS_BY_MATERIAL.computeIfAbsent(variant, GET_ITEMS_BY_MATERIAL);
    }

    public static void addKnownVariant(MaterialVariantId variant) {
        LISTENER.checkClear();
        KNOWN_VARIANTS.put((Object)variant.getId(), (Object)variant);
        SORTED_VARIANTS = null;
    }

    public static Collection<MaterialVariantId> getVariants(MaterialId materialId) {
        Collection variants = KNOWN_VARIANTS.get((Object)materialId);
        if (variants.isEmpty()) {
            return List.of(materialId);
        }
        return Collections.unmodifiableCollection(variants);
    }

    public static List<MaterialVariantId> getAllVariants() {
        if (SORTED_VARIANTS == null) {
            Comparator<MaterialVariantId> variantSorter = Comparator.comparing(MaterialVariantId::getVariant);
            SORTED_VARIANTS = MaterialRegistry.getInstance().getVisibleMaterials().stream().flatMap(material -> {
                MaterialId id = material.getIdentifier();
                Collection variants = KNOWN_VARIANTS.get((Object)id);
                if (variants.isEmpty()) {
                    return Stream.of(id);
                }
                return variants.stream().sorted(variantSorter);
            }).toList();
        }
        return SORTED_VARIANTS;
    }
}

