/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.worktable;

import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.json.predicate.modifier.ModifierPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.worktable.AbstractSizedIngredientRecipeBuilder;
import slimeknights.tconstruct.library.recipe.worktable.AbstractWorktableRecipe;
import slimeknights.tconstruct.library.recipe.worktable.ModifierSetWorktableRecipe;

public class ModifierSetWorktableRecipeBuilder
extends AbstractSizedIngredientRecipeBuilder<ModifierSetWorktableRecipeBuilder> {
    private final ResourceLocation dataKey;
    private IJsonPredicate<ModifierId> modifierPredicate = ModifierPredicate.ANY;
    private final boolean addToSet;
    private Ingredient tools = AbstractWorktableRecipe.DEFAULT_TOOLS;
    private boolean allowTraits = false;

    public static ModifierSetWorktableRecipeBuilder setAdding(ResourceLocation dataKey) {
        return new ModifierSetWorktableRecipeBuilder(dataKey, true);
    }

    public static ModifierSetWorktableRecipeBuilder setRemoving(ResourceLocation dataKey) {
        return new ModifierSetWorktableRecipeBuilder(dataKey, false);
    }

    public ModifierSetWorktableRecipeBuilder setTools(Ingredient ingredient) {
        this.tools = ingredient;
        return this;
    }

    public ModifierSetWorktableRecipeBuilder setTools(TagKey<Item> tag) {
        return this.setTools(Ingredient.m_204132_(tag));
    }

    public ModifierSetWorktableRecipeBuilder allowTraits() {
        this.allowTraits = true;
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, this.dataKey);
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.inputs.isEmpty()) {
            throw new IllegalStateException("Must have at least one ingredient");
        }
        if (this.tools == Ingredient.f_43901_) {
            throw new IllegalStateException("Tools cannot be empty");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new ModifierSetWorktableRecipe(id, this.dataKey, this.inputs, this.tools, this.modifierPredicate, this.addToSet, this.allowTraits), ModifierSetWorktableRecipe.LOADER, advancementId));
    }

    private ModifierSetWorktableRecipeBuilder(ResourceLocation dataKey, boolean addToSet) {
        this.dataKey = dataKey;
        this.addToSet = addToSet;
    }

    private ModifierSetWorktableRecipeBuilder(ResourceLocation dataKey, IJsonPredicate<ModifierId> modifierPredicate, boolean addToSet, Ingredient tools, boolean allowTraits) {
        this.dataKey = dataKey;
        this.modifierPredicate = modifierPredicate;
        this.addToSet = addToSet;
        this.tools = tools;
        this.allowTraits = allowTraits;
    }

    public ModifierSetWorktableRecipeBuilder modifierPredicate(IJsonPredicate<ModifierId> modifierPredicate) {
        this.modifierPredicate = modifierPredicate;
        return this;
    }
}

