/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierTraitHook;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.MultiplierNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolDataNBT;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.RestrictedCompoundTag;

public class ToolStack
implements IToolStackView {
    private static final String KEY_VALIDATE_SLOTS = TConstruct.makeTranslationKey("recipe", "modifier.validate_slots");
    public static final String TAG_MATERIALS = "tic_materials";
    public static final String TAG_PERSISTENT_MOD_DATA = "tic_persistent";
    public static final String TAG_UPGRADES = "tic_upgrades";
    public static final String TAG_BROKEN = "tic_broken";
    protected static final String TAG_STATS = "tic_stats";
    protected static final String TAG_MULTIPLIERS = "tic_multipliers";
    public static final String TAG_VOLATILE_MOD_DATA = "tic_volatile_data";
    public static final String TAG_MODIFIERS = "tic_modifiers";
    protected static final String TAG_DAMAGE = "Damage";
    private static final String TAG_UNBREAKABLE = "Unbreakable";
    private static final String TAG_HIDE_FLAGS = "HideFlags";
    private static final Set<String> RESTRICTED_TAGS = ImmutableSet.of((Object)"tic_materials", (Object)"tic_stats", (Object)"tic_multipliers", (Object)"tic_persistent", (Object)"tic_volatile_data", (Object)"tic_upgrades", (Object[])new String[]{"tic_modifiers", "tic_broken", "Damage", "HideFlags"});
    private final Item item;
    private final ToolDefinition definition;
    private final CompoundTag nbt;
    private RestrictedCompoundTag restrictedNBT;
    private int damage = -1;
    @Nullable
    private Boolean broken;
    @Nullable
    private MaterialNBT materials;
    @Nullable
    private ModifierNBT upgrades;
    @Nullable
    private ToolDataNBT persistentModData;
    @Nullable
    private ModifierNBT modifiers;
    @Nullable
    private StatsNBT stats;
    @Nullable
    private MultiplierNBT multipliers;
    @Nullable
    private IModDataView volatileModData;

    private static ToolStack from(ItemStack stack, boolean copyNbt) {
        ToolDefinition toolDefinition;
        Item item = stack.m_41720_();
        if (item instanceof IModifiable) {
            IModifiable mod = (IModifiable)item;
            toolDefinition = mod.getToolDefinition();
        } else {
            toolDefinition = ToolDefinition.EMPTY;
        }
        ToolDefinition definition = toolDefinition;
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
            if (!copyNbt) {
                if (definition != ToolDefinition.EMPTY) {
                    stack.f_41590_ = nbt;
                } else {
                    switch ((Config.Common.LogInvalidToolStack)((Object)Config.COMMON.logInvalidToolStack.get())) {
                        case STACKTRACE: {
                            TConstruct.LOG.warn("Tool stack constructed using non-modifiable tool, this may cause issues as it has no NBT. Stacktrace can be disabled in config.", (Throwable)new Exception("Stack trace"));
                            break;
                        }
                        case WARNING: {
                            TConstruct.LOG.warn("Tool stack constructed using non-modifiable tool, this may cause issues as it has no NBT. To debug this issue or disable the warning, use logInvalidToolStack in the config.");
                        }
                    }
                }
            }
        } else if (copyNbt) {
            nbt = nbt.m_6426_();
        }
        return ToolStack.from(item, definition, nbt);
    }

    public static ToolStack from(ItemStack stack) {
        return ToolStack.from(stack, false);
    }

    public static ToolStack copyFrom(ItemStack stack) {
        return ToolStack.from(stack, true);
    }

    public static ToolStack createTool(Item item, ToolDefinition definition, MaterialNBT materials) {
        ToolStack tool = ToolStack.from(item, definition, new CompoundTag());
        tool.damage = 0;
        tool.broken = false;
        tool.upgrades = ModifierNBT.EMPTY;
        tool.setMaterials(materials);
        return tool;
    }

    public ToolStack copy() {
        ToolStack tool = ToolStack.from(this.item, this.definition, this.nbt.m_6426_());
        tool.damage = this.damage;
        tool.broken = this.broken;
        tool.materials = this.materials;
        tool.upgrades = this.upgrades;
        tool.modifiers = this.modifiers;
        tool.stats = this.stats;
        return tool;
    }

    public void clearCache() {
        this.damage = -1;
        this.broken = null;
        this.materials = null;
        this.upgrades = null;
        this.modifiers = null;
        this.stats = null;
        this.multipliers = null;
        this.volatileModData = null;
        this.persistentModData = null;
    }

    public ItemStack createStack(int size) {
        ItemStack stack = new ItemStack((ItemLike)this.item, size);
        stack.f_41590_ = this.nbt;
        return stack;
    }

    public ItemStack createStack() {
        return this.createStack(1);
    }

    public ItemStack updateStack(ItemStack stack) {
        return this.updateStack(stack, true);
    }

    public ItemStack updateStack(ItemStack stack, boolean copyNBT) {
        if (stack.m_41720_() != this.item) {
            throw new IllegalArgumentException("Wrong item in stack");
        }
        stack.f_41590_ = copyNBT ? this.nbt.m_6426_() : this.nbt;
        if (!stack.f_41590_.m_128425_(TAG_DAMAGE, 99) && stack.m_41720_().isDamageable(stack)) {
            stack.f_41590_.m_128405_(TAG_DAMAGE, 0);
        }
        return stack;
    }

    public ItemStack copyStack(ItemStack stack) {
        return this.updateStack(stack.m_41777_(), false);
    }

    public ItemStack copyStack(ItemStack stack, int size) {
        return this.updateStack(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size), false);
    }

    public RestrictedCompoundTag getRestrictedNBT() {
        if (this.restrictedNBT == null) {
            this.restrictedNBT = new RestrictedCompoundTag(this.nbt, RESTRICTED_TAGS);
        }
        return this.restrictedNBT;
    }

    @Override
    public boolean isBroken() {
        if (this.broken == null) {
            this.broken = this.nbt.m_128471_(TAG_BROKEN);
        }
        return this.broken;
    }

    @Override
    public boolean isUnbreakable() {
        return this.nbt.m_128471_(TAG_UNBREAKABLE);
    }

    protected void setBrokenRaw(boolean broken) {
        this.broken = broken;
        this.nbt.m_128379_(TAG_BROKEN, broken);
    }

    protected void breakTool() {
        this.setDamage(this.getStats().getInt(ToolStats.DURABILITY));
    }

    protected int getDamageRaw() {
        if (this.damage == -1) {
            this.damage = this.nbt.m_128451_(TAG_DAMAGE);
        }
        return this.damage;
    }

    @Override
    public int getDamage() {
        int durability = this.getStats().getInt(ToolStats.DURABILITY);
        if (this.isBroken()) {
            return durability;
        }
        return Math.min(this.getDamageRaw(), durability - 1);
    }

    @Override
    public int getCurrentDurability() {
        if (this.isBroken()) {
            return 0;
        }
        return Math.max(0, this.getStats().getInt(ToolStats.DURABILITY) - this.getDamageRaw());
    }

    @Override
    public void setDamage(int damage) {
        int durability = this.getStats().getInt(ToolStats.DURABILITY);
        if (damage >= durability) {
            damage = Math.max(0, durability);
            this.setBrokenRaw(true);
        } else {
            this.setBrokenRaw(false);
        }
        this.damage = damage;
        this.nbt.m_128405_(TAG_DAMAGE, damage);
    }

    @Override
    public StatsNBT getStats() {
        if (this.stats == null) {
            this.stats = StatsNBT.readFromNBT(this.nbt.m_128423_(TAG_STATS));
        }
        return this.stats;
    }

    protected void setStats(StatsNBT stats) {
        this.stats = stats;
        this.nbt.m_128365_(TAG_STATS, (Tag)stats.serializeToNBT());
        int newMax = this.getStats().getInt(ToolStats.DURABILITY);
        if (this.getDamageRaw() >= newMax) {
            this.setDamage(newMax);
        }
    }

    @Override
    public MultiplierNBT getMultipliers() {
        if (this.multipliers == null) {
            this.multipliers = MultiplierNBT.readFromNBT(this.nbt.m_128423_(TAG_MULTIPLIERS));
        }
        return this.multipliers;
    }

    protected void setMultipliers(MultiplierNBT multipliers) {
        if (multipliers.getContainedStats().isEmpty()) {
            this.multipliers = MultiplierNBT.EMPTY;
            this.nbt.m_128473_(TAG_MULTIPLIERS);
        } else {
            this.multipliers = multipliers;
            this.nbt.m_128365_(TAG_MULTIPLIERS, (Tag)multipliers.serializeToNBT());
        }
    }

    @Override
    public MaterialNBT getMaterials() {
        if (!this.getDefinition().hasMaterials()) {
            return MaterialNBT.EMPTY;
        }
        if (this.materials == null) {
            this.materials = MaterialNBT.readFromNBT(this.nbt.m_128423_(TAG_MATERIALS));
        }
        return this.materials;
    }

    protected void setMaterialsRaw(MaterialNBT materials) {
        this.materials = materials;
        if (materials == MaterialNBT.EMPTY) {
            this.nbt.m_128473_(TAG_MATERIALS);
        } else {
            this.nbt.m_128365_(TAG_MATERIALS, (Tag)materials.serializeToNBT());
        }
    }

    public void setMaterials(MaterialNBT materials) {
        this.setMaterialsRaw(materials);
        this.rebuildStats();
    }

    public void replaceMaterial(int index, MaterialVariantId replacement) {
        this.setMaterials(this.getMaterials().replaceMaterial(index, replacement));
    }

    @Override
    public ModifierNBT getUpgrades() {
        if (this.upgrades == null) {
            this.upgrades = ModifierNBT.readFromNBT(this.nbt.m_128423_(TAG_UPGRADES));
        }
        return this.upgrades;
    }

    public void setUpgrades(ModifierNBT modifiers) {
        this.upgrades = modifiers;
        this.nbt.m_128365_(TAG_UPGRADES, (Tag)modifiers.serializeToNBT());
        this.rebuildStats();
    }

    public void addModifier(ModifierId modifier, int level) {
        if (level <= 0) {
            throw new IllegalArgumentException("Invalid level, must be above 0");
        }
        this.setUpgrades(this.getUpgrades().withModifier(modifier, level));
    }

    public void addModifierAmount(ModifierId modifier, int amount, int needed) {
        if (needed <= 0) {
            throw new IllegalArgumentException("Invalid needed, must be above 0");
        }
        if (amount > 0) {
            this.setUpgrades(this.getUpgrades().addAmount(modifier, amount, needed));
        }
    }

    public void removeModifier(ModifierId modifier, int level) {
        ModifierNBT newModifiers;
        if (level <= 0) {
            throw new IllegalArgumentException("Invalid level, must be above 0");
        }
        this.upgrades = newModifiers = this.getUpgrades().withoutModifier(modifier, level);
        this.nbt.m_128365_(TAG_UPGRADES, (Tag)newModifiers.serializeToNBT());
        this.rebuildStats();
    }

    @Override
    public ModifierNBT getModifiers() {
        if (this.modifiers == null) {
            this.modifiers = ModifierNBT.readFromNBT(this.nbt.m_128423_(TAG_MODIFIERS));
        }
        return this.modifiers;
    }

    protected void setModifiers(ModifierNBT modifiers) {
        this.modifiers = modifiers;
        this.nbt.m_128365_(TAG_MODIFIERS, (Tag)this.modifiers.serializeToNBT());
    }

    @Override
    public ToolDataNBT getPersistentData() {
        if (this.persistentModData == null) {
            if (this.nbt.m_128425_(TAG_PERSISTENT_MOD_DATA, 10)) {
                this.persistentModData = ToolDataNBT.readFromNBT(this.nbt.m_128469_(TAG_PERSISTENT_MOD_DATA));
            } else {
                CompoundTag tag = new CompoundTag();
                this.nbt.m_128365_(TAG_PERSISTENT_MOD_DATA, (Tag)tag);
                this.persistentModData = ToolDataNBT.readFromNBT(tag);
            }
        }
        return this.persistentModData;
    }

    @Override
    public IModDataView getVolatileData() {
        if (this.volatileModData == null) {
            this.volatileModData = this.nbt.m_128425_(TAG_VOLATILE_MOD_DATA, 10) ? ToolDataNBT.readFromNBT(this.nbt.m_128469_(TAG_VOLATILE_MOD_DATA)) : IModDataView.EMPTY;
        }
        return this.volatileModData;
    }

    protected void setVolatileModData(ToolDataNBT modData) {
        CompoundTag data = modData.getData();
        if (data.m_128456_()) {
            this.volatileModData = IModDataView.EMPTY;
            this.nbt.m_128473_(TAG_VOLATILE_MOD_DATA);
        } else {
            this.volatileModData = modData;
            this.nbt.m_128365_(TAG_VOLATILE_MOD_DATA, (Tag)data);
        }
    }

    @Nullable
    public Component tryValidate() {
        for (SlotType slotType : SlotType.getAllSlotTypes()) {
            if (this.getFreeSlots(slotType) >= 0) continue;
            return Component.m_237110_((String)KEY_VALIDATE_SLOTS, (Object[])new Object[]{slotType.getDisplayName()});
        }
        for (ModifierEntry entry : this.getModifierList()) {
            Component result = entry.getHook(ModifierHooks.VALIDATE).validate(this, entry);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void ensureHasData() {
        if (this.definition.isDataLoaded()) {
            boolean needsMaterials;
            boolean bl = needsMaterials = this.definition.hasMaterials() && !this.nbt.m_128425_(TAG_MATERIALS, 9);
            if (needsMaterials || !ToolStack.isInitialized(this.nbt)) {
                if (needsMaterials) {
                    this.setMaterialsRaw(this.definition.getHook(ToolHooks.MISSING_MATERIALS).fillMaterials(this.definition, RandomSource.m_216327_()));
                }
                this.rebuildStats();
            }
        }
    }

    public void rebuildStats() {
        if (!(this.definition.isDataLoaded() && MaterialRegistry.isFullyLoaded() && ModifierManager.INSTANCE.isDynamicModifiersLoaded() && TinkerTags.isTagsLoaded())) {
            return;
        }
        ToolDefinitionData toolData = this.getDefinitionData();
        MaterialNBT materials = this.getMaterials();
        ModifierNBT.Builder modBuilder = ModifierNBT.builder();
        modBuilder.add(this.getUpgrades());
        toolData.getHook(ToolHooks.TOOL_TRAITS).addTraits(this.definition, materials, modBuilder);
        ModifierNBT beforeTraits = modBuilder.build();
        ToolRebuildContext context = new ToolRebuildContext(this.item, this.definition, materials, this.getUpgrades(), beforeTraits, this.getPersistentData());
        List<Object> modifierList = Collections.emptyList();
        if (beforeTraits.isEmpty()) {
            this.setModifiers(ModifierNBT.EMPTY);
        } else {
            modBuilder = ModifierNBT.builder();
            ModifierTraitHook.TraitBuilder traitBuilder = new ModifierTraitHook.TraitBuilder(context, modBuilder);
            traitBuilder.add(beforeTraits);
            ModifierNBT allMods = modBuilder.build();
            this.setModifiers(allMods);
            modifierList = allMods.getModifiers();
            context = context.withModifiers(allMods);
        }
        ToolDataNBT volatileData = new ToolDataNBT();
        toolData.getHook(ToolHooks.VOLATILE_DATA).addVolatileData(context, volatileData);
        for (ModifierEntry modifierEntry : modifierList) {
            modifierEntry.getHook(ModifierHooks.VOLATILE_DATA).addVolatileData(context, modifierEntry, volatileData);
        }
        this.setVolatileModData(volatileData);
        ModifierStatsBuilder statBuilder = ModifierStatsBuilder.builder();
        toolData.getHook(ToolHooks.TOOL_STATS).addToolStats(context, statBuilder);
        for (ModifierEntry modifierEntry : modifierList) {
            modifierEntry.getHook(ModifierHooks.TOOL_STATS).addToolStats(context, modifierEntry, statBuilder);
        }
        this.setStats(statBuilder.build());
        this.setMultipliers(statBuilder.buildMultipliers());
        for (ModifierEntry modifierEntry : modifierList) {
            modifierEntry.getHook(ModifierHooks.RAW_DATA).addRawData(this, modifierEntry, this.getRestrictedNBT());
        }
    }

    public static boolean isInitialized(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && ToolStack.isInitialized(tag);
    }

    public static boolean isInitialized(CompoundTag tag) {
        return tag.m_128425_(TAG_STATS, 10);
    }

    public static void ensureInitialized(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IModifiable) {
            IModifiable modifiable = (IModifiable)item;
            ToolStack.ensureInitialized(stack, modifiable.getToolDefinition());
        }
    }

    public static void ensureInitialized(ItemStack stack, ToolDefinition toolDefinition) {
        if (!toolDefinition.isDataLoaded()) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag != null && ToolStack.isInitialized(tag)) {
            return;
        }
        ToolStack.from(stack).ensureHasData();
    }

    public static void verifyTag(Item item, CompoundTag tag, ToolDefinition definition) {
        MaterialIdNBT stored;
        MaterialIdNBT resolved;
        boolean hasMaterials;
        if (tag.m_128471_("tic_display")) {
            return;
        }
        boolean bl = hasMaterials = MaterialRegistry.isFullyLoaded() && tag.m_128425_(TAG_MATERIALS, 9);
        if (hasMaterials && (resolved = (stored = MaterialIdNBT.readFromNBT((Tag)tag.m_128437_(TAG_MATERIALS, 8))).resolveRedirects()) != stored) {
            resolved.updateNBT(tag);
        }
        if (definition.isDataLoaded() && (hasMaterials || !definition.hasMaterials())) {
            ToolStack.from(item, definition, tag).rebuildStats();
        }
    }

    private ToolStack(Item item, ToolDefinition definition, CompoundTag nbt) {
        this.item = item;
        this.definition = definition;
        this.nbt = nbt;
    }

    public static ToolStack from(Item item, ToolDefinition definition, CompoundTag nbt) {
        return new ToolStack(item, definition, nbt);
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public ToolDefinition getDefinition() {
        return this.definition;
    }

    protected CompoundTag getNbt() {
        return this.nbt;
    }
}

