/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.module;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuelLookup;
import slimeknights.tconstruct.library.utils.Util;

public abstract class FuelModule
implements ContainerData {
    protected final NonNullConsumer<LazyOptional<IFluidHandler>> fluidListener = new WeakConsumerWrapper((Object)this, FuelModule::resetHandler);
    protected final MantleBlockEntity parent;
    @Nullable
    private MeltingFuel lastRecipe;
    @Nullable
    protected LazyOptional<IFluidHandler> fluidHandler;
    protected int fuel = 0;
    protected int fuelQuality = 0;
    protected int temperature = 0;
    protected int rate = 0;
    private static final String TAG_FUEL = "fuel";
    private static final String TAG_TEMPERATURE = "temperature";
    private static final String TAG_RATE = "rate";
    private static final int FUEL = 0;
    private static final int FUEL_QUALITY = 1;
    private static final int TEMPERATURE = 2;
    private static final int RATE = 3;

    protected void resetHandler(@Nullable LazyOptional<?> source) {
        if (source == null || source == this.fluidHandler) {
            if (source != this.fluidHandler && Util.isForge()) {
                this.fluidHandler.removeListener(this.fluidListener);
            }
            this.fluidHandler = null;
        }
    }

    protected Level getLevel() {
        return Objects.requireNonNull(this.parent.m_58904_(), "Parent tile entity has null world");
    }

    @Nullable
    protected MeltingFuel findRecipe(Fluid fluid) {
        if (this.lastRecipe != null && this.lastRecipe.matches(fluid)) {
            return this.lastRecipe;
        }
        MeltingFuel recipe = MeltingFuelLookup.findFuel(fluid);
        if (recipe != null) {
            this.lastRecipe = recipe;
        }
        return recipe;
    }

    public boolean hasFuel() {
        return this.fuel > 0;
    }

    public void decreaseFuel(int amount) {
        this.fuel = Math.max(0, this.fuel - amount);
        this.parent.setChangedFast();
    }

    protected int tryLiquidFuel(IFluidHandler handler, boolean consume) {
        FluidStack fluid = handler.getFluidInTank(0);
        MeltingFuel recipe = this.findRecipe(fluid.getFluid());
        if (recipe != null) {
            int amount = recipe.getAmount(fluid.getFluid());
            if (fluid.getAmount() >= amount) {
                if (consume) {
                    FluidStack drained = handler.drain(new FluidStack(fluid, amount), IFluidHandler.FluidAction.EXECUTE);
                    if (drained.getAmount() != amount) {
                        TConstruct.LOG.error("Invalid amount of fuel drained from tank");
                    }
                    this.fuel += recipe.getDuration();
                    this.fuelQuality = recipe.getDuration();
                    this.temperature = recipe.getTemperature();
                    this.rate = recipe.getRate();
                    this.parent.setChangedFast();
                    return this.temperature;
                }
                return recipe.getTemperature();
            }
        }
        return 0;
    }

    public abstract int findFuel(boolean var1);

    public void readFromTag(CompoundTag nbt) {
        if (nbt.m_128425_(TAG_FUEL, 99)) {
            this.fuel = nbt.m_128451_(TAG_FUEL);
        }
        if (nbt.m_128425_(TAG_TEMPERATURE, 99)) {
            this.temperature = nbt.m_128451_(TAG_TEMPERATURE);
            this.rate = nbt.m_128451_(TAG_RATE);
        }
    }

    public CompoundTag writeToTag(CompoundTag nbt) {
        nbt.m_128405_(TAG_FUEL, this.fuel);
        nbt.m_128405_(TAG_TEMPERATURE, this.temperature);
        nbt.m_128405_(TAG_RATE, this.rate);
        return nbt;
    }

    public int m_6499_() {
        return 4;
    }

    public int m_6413_(int index) {
        return switch (index) {
            case 0 -> this.fuel;
            case 1 -> this.fuelQuality;
            case 2 -> this.temperature;
            case 3 -> this.rate;
            default -> 0;
        };
    }

    public void m_8050_(int index, int value) {
        switch (index) {
            case 0: {
                this.fuel = value;
                break;
            }
            case 1: {
                this.fuelQuality = value;
                break;
            }
            case 2: {
                this.temperature = value;
                break;
            }
            case 3: {
                this.rate = value;
            }
        }
    }

    public FuelInfo getFuelInfo() {
        if (this.fluidHandler == null) {
            return FuelInfo.EMPTY;
        }
        return this.fluidHandler.map(handler -> {
            MeltingFuel fuel;
            FluidStack fluid = handler.getFluidInTank(0);
            int temperature = 0;
            if (!fluid.isEmpty() && (fuel = this.findRecipe(fluid.getFluid())) != null) {
                temperature = fuel.getTemperature();
            }
            return FuelInfo.of(fluid, handler.getTankCapacity(0), temperature);
        }).orElse(FuelInfo.EMPTY);
    }

    public FuelModule(MantleBlockEntity parent) {
        this.parent = parent;
    }

    public int getFuel() {
        return this.fuel;
    }

    public int getFuelQuality() {
        return this.fuelQuality;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getRate() {
        return this.rate;
    }

    public static class FuelInfo {
        public static final FuelInfo EMPTY = new FuelInfo(FluidStack.EMPTY, 0, 0, 0);
        public static final FuelInfo ITEM = new FuelInfo(FluidStack.EMPTY, 0, 0, 0);
        private final FluidStack fluid;
        private int totalAmount;
        private int capacity;
        private final int temperature;

        public static FuelInfo of(FluidStack fluid, int capacity, int temperature) {
            if (fluid.isEmpty()) {
                return EMPTY;
            }
            return new FuelInfo(fluid, fluid.getAmount(), Math.max(capacity, fluid.getAmount()), temperature);
        }

        protected void add(int amount, int capacity) {
            this.totalAmount += amount;
            this.capacity += capacity;
        }

        public boolean isItem() {
            return this == ITEM;
        }

        public boolean isEmpty() {
            return this.fluid.isEmpty() || this.totalAmount == 0 || this.capacity == 0;
        }

        public FluidStack getFluid() {
            return this.fluid;
        }

        public int getTotalAmount() {
            return this.totalAmount;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public int getTemperature() {
            return this.temperature;
        }

        private FuelInfo(FluidStack fluid, int totalAmount, int capacity, int temperature) {
            this.fluid = fluid;
            this.totalAmount = totalAmount;
            this.capacity = capacity;
            this.temperature = temperature;
        }
    }
}

