/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.multiblock;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.common.multiblock.IMasterLogic;
import slimeknights.tconstruct.common.multiblock.IServantLogic;
import slimeknights.tconstruct.smeltery.block.component.SearedBlock;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.MultiblockCuboid;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.MultiblockResult;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.MultiblockStructureData;

public abstract class HeatingStructureMultiblock<T extends MantleBlockEntity>
extends MultiblockCuboid<StructureData> {
    private static final String TAG_TANKS = "tanks";
    private static final String TAG_INSIDE_CHECK = "insideCheck";
    protected final T parent;
    protected final List<BlockPos> tanks = new ArrayList<BlockPos>();

    public HeatingStructureMultiblock(T parent, boolean hasFloor, boolean hasFrame, boolean hasCeiling, int maxHeight, int innerLimit) {
        super(hasFloor, hasFrame, hasCeiling, maxHeight, innerLimit);
        this.parent = parent;
    }

    public HeatingStructureMultiblock(T parent, boolean hasFloor, boolean hasFrame, boolean hasCeiling) {
        super(hasFloor, hasFrame, hasCeiling);
        this.parent = parent;
    }

    @Override
    public StructureData create(BlockPos min, BlockPos max, Set<BlockPos> extraPos) {
        this.tanks.removeIf(pos -> !MultiblockStructureData.isWithin(pos, min, max));
        return new StructureData(min, max, extraPos, this.hasFloor, this.hasFrame, this.hasCeiling, (List<BlockPos>)ImmutableList.copyOf(this.tanks));
    }

    public StructureData createClient(BlockPos min, BlockPos max, List<BlockPos> tanks) {
        return new StructureData(min, max, Collections.emptySet(), this.hasFloor, this.hasFrame, this.hasCeiling, tanks);
    }

    @Override
    public StructureData detectMultiblock(Level world, BlockPos master, Direction facing) {
        this.tanks.clear();
        return (StructureData)super.detectMultiblock(world, master, facing);
    }

    @Override
    @Nullable
    public StructureData readFromTag(CompoundTag nbt, BlockPos controllerPos) {
        this.tanks.clear();
        this.tanks.addAll(HeatingStructureMultiblock.readPosList(nbt, TAG_TANKS, controllerPos));
        return (StructureData)super.readFromTag(nbt, controllerPos);
    }

    protected boolean isValidSlave(Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof IServantLogic) {
            IServantLogic servant = (IServantLogic)te;
            return servant.isValidMaster((IMasterLogic)this.parent);
        }
        return true;
    }

    public boolean canExpand(StructureData data, Level world) {
        BlockPos from;
        BlockPos to;
        BlockPos min = data.getMinPos();
        BlockPos max = data.getMaxPos();
        if (this.hasFloor) {
            to = max.m_7494_();
            from = new BlockPos(min.m_123341_(), to.m_123342_(), min.m_123343_());
        } else {
            from = min.m_7495_();
            to = new BlockPos(max.m_123341_(), from.m_123342_(), max.m_123343_());
        }
        MultiblockResult result = this.detectLayer(world, from, to, pos -> {});
        this.setLastResult(result);
        return result.isSuccess();
    }

    protected abstract boolean isValidBlock(Block var1);

    protected abstract boolean isValidFloor(Block var1);

    protected abstract boolean isValidTank(Block var1);

    protected abstract boolean isValidWall(Block var1);

    @Override
    protected boolean isValidBlock(Level world, BlockPos pos, MultiblockCuboid.CuboidSide side, boolean isFrame) {
        if (pos.equals((Object)this.parent.m_58899_())) {
            return true;
        }
        BlockState state = world.m_8055_(pos);
        if (!state.m_61138_((Property)SearedBlock.IN_STRUCTURE)) {
            return false;
        }
        if (((Boolean)state.m_61143_((Property)SearedBlock.IN_STRUCTURE)).booleanValue() && !this.isValidSlave(world, pos)) {
            return false;
        }
        if (side == MultiblockCuboid.CuboidSide.FLOOR && !isFrame) {
            return this.isValidFloor(state.m_60734_());
        }
        if (this.isValidTank(state.m_60734_())) {
            this.tanks.add(pos.m_7949_());
            return true;
        }
        return this.isValidWall(state.m_60734_());
    }

    @Override
    public boolean shouldUpdate(Level world, MultiblockStructureData structure, BlockPos pos, BlockState state) {
        if (structure.withinBounds(pos)) {
            if (structure.contains(pos)) {
                return !this.isValidBlock(state.m_60734_());
            }
            return structure.isInside(pos) && !HeatingStructureMultiblock.isAirBlock(state);
        }
        return structure.isDirectlyAbove(pos) && this.isValidWall(state.m_60734_());
    }

    public static class StructureData
    extends MultiblockStructureData {
        private final List<BlockPos> tanks;
        private BlockPos insideCheck;

        protected StructureData(BlockPos minPos, BlockPos maxPos, Set<BlockPos> extraPositions, boolean hasFloor, boolean hasFrame, boolean hasCeiling, List<BlockPos> tanks) {
            super(minPos, maxPos, extraPositions, hasFloor, hasFrame, hasCeiling);
            this.tanks = tanks;
        }

        public boolean hasTanks() {
            return !this.tanks.isEmpty();
        }

        private BlockPos getNextInsideCheck(@Nullable BlockPos prev) {
            BlockPos min = this.getMinInside();
            if (prev == null) {
                return min;
            }
            if (prev.m_123341_() < min.m_123341_() || prev.m_123342_() < min.m_123342_() || prev.m_123343_() < min.m_123343_()) {
                return min;
            }
            BlockPos max = this.getMaxInside();
            if (prev.m_123343_() >= max.m_123343_()) {
                if (prev.m_123341_() >= max.m_123341_()) {
                    if (prev.m_123342_() >= max.m_123342_()) {
                        return min;
                    }
                    return new BlockPos(min.m_123341_(), prev.m_123342_() + 1, min.m_123343_());
                }
                return new BlockPos(prev.m_123341_() + 1, prev.m_123342_(), min.m_123343_());
            }
            return prev.m_7918_(0, 0, 1);
        }

        public BlockPos getNextInsideCheck() {
            this.insideCheck = this.getNextInsideCheck(this.insideCheck);
            return this.insideCheck;
        }

        public int getPerimeterCount() {
            BlockPos min = this.getMinInside();
            BlockPos max = this.getMaxInside();
            int dx = max.m_123341_() - min.m_123341_();
            int dy = max.m_123342_() - min.m_123342_();
            int dz = max.m_123343_() - min.m_123343_();
            return 2 * (dx * dy) + 2 * (dy * dz) + dx * dz;
        }

        @Override
        public CompoundTag writeClientTag(BlockPos controllerPos) {
            CompoundTag nbt = super.writeClientTag(controllerPos);
            nbt.m_128365_(HeatingStructureMultiblock.TAG_TANKS, (Tag)StructureData.writePosList(this.tanks, controllerPos));
            return nbt;
        }

        @Override
        public CompoundTag writeToTag(BlockPos controllerPos) {
            CompoundTag nbt = super.writeToTag(controllerPos);
            if (this.insideCheck != null) {
                nbt.m_128365_(HeatingStructureMultiblock.TAG_INSIDE_CHECK, (Tag)NbtUtils.m_129224_((BlockPos)this.insideCheck.m_121996_((Vec3i)controllerPos)));
            }
            return nbt;
        }

        public List<BlockPos> getTanks() {
            return this.tanks;
        }
    }
}

