/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.item;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import slimeknights.mantle.fluid.FluidTransferHelper;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.mantle.fluid.transfer.FluidContainerTransferManager;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.block.entity.component.TankBlockEntity;
import slimeknights.tconstruct.smeltery.item.ScaledFluidTank;
import slimeknights.tconstruct.smeltery.item.TankItemFluidHandler;

public class TankItem
extends BlockTooltipItem {
    private static final Predicate<FluidStack> NO_FILL = FluidStack::isEmpty;
    private final boolean limitStackSize;

    public TankItem(Block blockIn, Item.Properties builder, boolean limitStackSize) {
        super(blockIn, builder);
        this.limitStackSize = limitStackSize;
    }

    private static boolean isFilled(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128425_("tank", 10);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return TankItem.isFilled(stack);
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return TankItem.isFilled(stack) ? new ItemStack((ItemLike)this) : ItemStack.f_41583_;
    }

    public int getMaxStackSize(ItemStack stack) {
        if (!this.limitStackSize) {
            return super.getMaxStackSize(stack);
        }
        return TankItem.isFilled(stack) ? 16 : 64;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            FluidTank tank = TankItem.getTank(stack, 1);
            if (tank.getFluidAmount() > 0) {
                FluidStack fluid = tank.getFluid();
                tooltip.add((Component)fluid.getDisplayName().m_6879_().m_130940_(ChatFormatting.GRAY));
                FluidTooltipHandler.appendMaterial((FluidStack)fluid, tooltip);
            }
        } else {
            super.m_7373_(stack, worldIn, tooltip, flagIn);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new TankItemFluidHandler(this, stack);
    }

    public static boolean mayHaveFluid(ItemStack stack) {
        return FluidContainerTransferManager.INSTANCE.mayHaveTransfer(stack) || stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
    }

    public boolean m_142207_(ItemStack held, Slot slot, ClickAction action, Player player) {
        ItemStack slotStack;
        if (action == ClickAction.SECONDARY && slot.m_150651_(player) && !(slotStack = slot.m_7993_()).m_41619_() && held.m_41720_() != slotStack.m_41720_() && TankItem.mayHaveFluid(slotStack)) {
            if (slotStack.m_41613_() == 1) {
                FluidTank tank = TankItem.getTank(held, 1);
                IFluidContainerTransfer.TransferResult result = FluidTransferHelper.interactWithStack((IFluidHandler)tank, (ItemStack)slotStack, (IFluidContainerTransfer.TransferDirection)IFluidContainerTransfer.TransferDirection.REVERSE);
                if (result != null) {
                    if (player.m_9236_().f_46443_) {
                        player.m_216990_(result.getSound());
                    }
                    slot.m_5852_(FluidTransferHelper.getOrTransferFilled((Player)player, (ItemStack)slotStack, (ItemStack)result.stack()));
                    if (held.m_41613_() == 1) {
                        TankItem.setTank(held, tank);
                    } else {
                        ItemStack split = held.m_41620_(1);
                        TankItem.setTank(split, tank);
                        if (!player.m_150109_().m_36054_(split)) {
                            player.m_36176_(split, false);
                        }
                    }
                }
            } else if (slotStack.m_246617_(player.m_9236_().m_246046_())) {
                final AbstractContainerMenu menu = player.f_36096_;
                slotStack.m_150932_(held, slot, action, player, new SlotAccess(){

                    public ItemStack m_142196_() {
                        return menu.m_142621_();
                    }

                    public boolean m_142104_(ItemStack stack) {
                        menu.m_142503_(stack);
                        return true;
                    }
                });
            }
            return true;
        }
        return false;
    }

    public static void updateHeldItem(Player player, ItemStack held, ItemStack result) {
        if (player.f_36096_.m_142621_() == held) {
            player.f_36096_.m_142503_(FluidTransferHelper.getOrTransferFilled((Player)player, (ItemStack)held, (ItemStack)result));
        } else if (!player.m_150109_().m_36054_(result)) {
            player.m_36176_(result, false);
        }
    }

    public boolean m_142305_(ItemStack stack, ItemStack held, Slot slot, ClickAction action, Player player, SlotAccess pAccess) {
        if (action == ClickAction.SECONDARY && slot.m_150651_(player) && !held.m_41619_() && TankItem.mayHaveFluid(held)) {
            if (stack.m_41613_() == 1 || held.m_41720_() instanceof TankItem) {
                FluidTank tank = this.getTank(stack);
                if (tank.isEmpty() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)held)) {
                    return false;
                }
                IFluidContainerTransfer.TransferResult result = FluidTransferHelper.interactWithStack((IFluidHandler)tank, (ItemStack)held, (IFluidContainerTransfer.TransferDirection)IFluidContainerTransfer.TransferDirection.AUTO);
                if (result != null) {
                    if (player.m_9236_().f_46443_) {
                        player.m_216990_(result.getSound());
                    }
                    TankItem.setTank(stack, tank);
                    TankItem.updateHeldItem(player, held, result.stack());
                }
            }
            return true;
        }
        return false;
    }

    private static void removeTank(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            nbt.m_128473_("tank");
            if (nbt.m_128456_()) {
                stack.m_41751_(null);
            }
        }
    }

    public static ItemStack setTank(ItemStack stack, FluidTank tank) {
        if (tank.isEmpty()) {
            TankItem.removeTank(stack);
        } else {
            stack.m_41784_().m_128365_("tank", (Tag)tank.writeToNBT(new CompoundTag()));
        }
        return stack;
    }

    public static ItemStack setTank(ItemStack stack, FluidStack fluid) {
        if (fluid.isEmpty()) {
            TankItem.removeTank(stack);
        } else {
            stack.m_41784_().m_128365_("tank", (Tag)fluid.writeToNBT(new CompoundTag()));
        }
        return stack;
    }

    private static ItemStack setTank(ItemLike item, ResourceLocation fluid, int amount) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("FluidName", fluid.toString());
        tag.m_128405_("Amount", amount);
        ItemStack stack = new ItemStack(item);
        stack.m_41784_().m_128365_("tank", (Tag)tag);
        return stack;
    }

    public FluidTank getTank(ItemStack stack) {
        int count = stack.m_41613_();
        FluidTank tank = TankItem.getTank(stack, count);
        if (this.limitStackSize && count > 16) {
            tank.setValidator(NO_FILL);
        }
        return tank;
    }

    public static FluidTank getTank(ItemStack stack, int scale) {
        FluidTank tank = ScaledFluidTank.create(TankBlockEntity.getCapacity(stack.m_41720_()), scale);
        if (stack.m_41782_()) {
            assert (stack.m_41783_() != null);
            tank.readFromNBT(stack.m_41783_().m_128469_("tank"));
        }
        return tank;
    }

    public static String getSubtype(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("tank", 10)) {
            return nbt.m_128469_("tank").m_128461_("FluidName");
        }
        return "";
    }

    public static void addFilledVariants(Consumer<ItemStack> output) {
        BuiltInRegistries.f_257020_.m_203611_().filter(holder -> {
            Fluid fluid = (Fluid)holder.get();
            return fluid.m_7444_(fluid.m_76145_()) && !holder.m_203656_(TinkerTags.Fluids.HIDE_IN_CREATIVE_TANKS);
        }).forEachOrdered(holder -> {
            SearedTankBlock.TankType gauge;
            SearedTankBlock.TankType tank;
            if (holder.m_203656_(TinkerTags.Fluids.METAL_TOOLTIPS)) {
                tank = SearedTankBlock.TankType.INGOT_TANK;
                gauge = SearedTankBlock.TankType.INGOT_GAUGE;
            } else {
                tank = SearedTankBlock.TankType.FUEL_TANK;
                gauge = SearedTankBlock.TankType.FUEL_GAUGE;
            }
            ResourceLocation fluidName = holder.m_205785_().m_135782_();
            output.accept(TankItem.setTank(TinkerSmeltery.searedLantern, fluidName, 50));
            output.accept(TankItem.fillTank(TinkerSmeltery.searedTank, tank, fluidName));
            output.accept(TankItem.fillTank(TinkerSmeltery.searedTank, gauge, fluidName));
            output.accept(TankItem.setTank(TinkerSmeltery.scorchedLantern, fluidName, 50));
            output.accept(TankItem.fillTank(TinkerSmeltery.scorchedTank, tank, fluidName));
            output.accept(TankItem.fillTank(TinkerSmeltery.scorchedTank, gauge, fluidName));
        });
    }

    public static ItemStack fillTank(EnumObject<SearedTankBlock.TankType, ? extends ItemLike> tank, SearedTankBlock.TankType type, Fluid fluid) {
        return TankItem.setTank(new ItemStack((ItemLike)tank.get((Enum)type)), new FluidStack(fluid, type.getCapacity()));
    }

    public static ItemStack fillTank(EnumObject<SearedTankBlock.TankType, ? extends ItemLike> tank, SearedTankBlock.TankType type, ResourceLocation fluid) {
        return TankItem.setTank((ItemLike)tank.get((Enum)type), fluid, type.getCapacity());
    }
}

