/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.tools.logic.InteractionHandler;

public enum InteractWithAirPacket implements IThreadsafePacket
{
    MAINHAND(InteractionHand.MAIN_HAND),
    OFFHAND(InteractionHand.OFF_HAND),
    LEFT_CLICK(InteractionHand.MAIN_HAND);

    private final InteractionHand hand;

    public static InteractWithAirPacket fromChestplate(InteractionHand hand) {
        return hand == InteractionHand.OFF_HAND ? OFFHAND : MAINHAND;
    }

    public static InteractWithAirPacket read(FriendlyByteBuf buffer) {
        return (InteractWithAirPacket)buffer.m_130066_(InteractWithAirPacket.class);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player != null && !player.m_5833_()) {
            if (this == LEFT_CLICK) {
                InteractionResult result;
                ItemStack held = player.m_21120_(this.hand);
                if (held.m_204117_(TinkerTags.Items.INTERACTABLE_LEFT) && (result = InteractionHandler.onLeftClickInteraction((Player)player, held, this.hand)).m_19080_()) {
                    player.m_21011_(this.hand, true);
                }
            } else {
                InteractionResult result;
                ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
                if (chestplate.m_204117_(TinkerTags.Items.INTERACTABLE_ARMOR) && player.m_21120_(this.hand).m_41619_() && (result = InteractionHandler.onChestplateUse((Player)player, chestplate, this.hand)).m_19080_()) {
                    player.m_21011_(this.hand, true);
                }
            }
        }
    }

    private InteractWithAirPacket(InteractionHand hand) {
        this.hand = hand;
    }
}

