/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.AlmostUnifiedFallbackRuntime;
import com.almostreliable.unified.compat.HideHelper;
import com.almostreliable.unified.compat.RecipeIndicator;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.recipe.CRTLookup;
import com.almostreliable.unified.recipe.ClientRecipeTracker;
import com.almostreliable.unified.utils.Utils;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.shedaniel.rei.plugincompatibilities.api.REIPluginCompatIgnore;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryDecorator;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

@REIPluginCompatIgnore
@JeiPlugin
public class AlmostJEI
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return Utils.getRL("jei");
    }

    public void onRuntimeAvailable(IJeiRuntime jei) {
        AlmostUnifiedFallbackRuntime.getInstance().reload();
        Boolean jeiDisabled = AlmostUnified.getRuntime().getUnifyConfig().map(UnifyConfig::reiOrJeiDisabled).orElse(false);
        if (jeiDisabled.booleanValue()) {
            return;
        }
        Collection<ItemStack> items = HideHelper.getStacksToHide();
        if (!items.isEmpty()) {
            jei.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, items);
        }
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        Stream recipeTypes = registration.getJeiHelpers().getAllRecipeTypes();
        recipeTypes.forEach(rt -> registration.addRecipeCategoryDecorator(rt, new Decorator()));
    }

    private static class Decorator<T>
    implements IRecipeCategoryDecorator<T> {
        private static final int RECIPE_BORDER_PADDING = 4;

        private Decorator() {
        }

        public void draw(T recipe, IRecipeCategory<T> recipeCategory, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
            ClientRecipeTracker.ClientRecipeLink recipeLink = Decorator.resolveLink(recipeCategory, recipe);
            if (recipeLink == null) {
                return;
            }
            int pX = recipeCategory.getWidth() + 8 - 10;
            int pY = recipeCategory.getHeight() + 8 - 10;
            RecipeIndicator.renderIndicator(guiGraphics, pX, pY, 10);
            if (mouseX >= (double)pX && mouseX <= (double)(pX + 10) && mouseY >= (double)pY && mouseY <= (double)(pY + 10)) {
                RecipeIndicator.renderTooltip(guiGraphics, recipeLink, mouseX, mouseY);
            }
        }

        @Nullable
        private static <R> ClientRecipeTracker.ClientRecipeLink resolveLink(IRecipeCategory<R> recipeCategory, R recipe) {
            ResourceLocation recipeId = recipeCategory.getRegistryName(recipe);
            if (recipeId == null) {
                return null;
            }
            return CRTLookup.getLink(recipeId);
        }
    }
}

