/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.AlmostUnifiedRuntime;
import com.almostreliable.unified.utils.ReplacementMap;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.TagOwnerships;
import com.almostreliable.unified.utils.UnifyTag;
import com.almostreliable.unified.utils.Utils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class HideHelper {
    private HideHelper() {
    }

    public static Multimap<UnifyTag<Item>, ResourceLocation> createHidingMap() {
        AlmostUnifiedRuntime runtime = AlmostUnified.getRuntime();
        ReplacementMap repMap = runtime.getReplacementMap().orElse(null);
        TagMap tagMap = runtime.getFilteredTagMap().orElse(null);
        HashMultimap hidingMap = HashMultimap.create();
        if (repMap == null || tagMap == null) {
            return hidingMap;
        }
        TagOwnerships ownerships = repMap.getTagOwnerships();
        for (UnifyTag<Item> unifyTag : tagMap.getTags()) {
            Set<ResourceLocation> refItemsToHide;
            Set<ResourceLocation> itemsByTag = tagMap.getEntriesByTag(unifyTag);
            if (Utils.allSameNamespace(itemsByTag)) continue;
            HashSet<ResourceLocation> replacements = new HashSet<ResourceLocation>();
            for (ResourceLocation item : itemsByTag) {
                ResourceLocation replacement = repMap.getReplacementForItem(item);
                replacements.add(replacement == null ? item : replacement);
            }
            Set<ResourceLocation> itemsToHide = HideHelper.getItemsToHide(unifyTag, itemsByTag, replacements);
            if (itemsToHide != null) {
                hidingMap.putAll(unifyTag, itemsToHide);
            }
            if ((refItemsToHide = HideHelper.getRefItemsToHide(unifyTag, ownerships, replacements)).isEmpty()) continue;
            hidingMap.putAll(unifyTag, refItemsToHide);
        }
        return hidingMap;
    }

    @Nullable
    private static Set<ResourceLocation> getItemsToHide(UnifyTag<Item> unifyTag, Set<ResourceLocation> itemsByTag, Set<ResourceLocation> replacements) {
        HashSet<ResourceLocation> itemsToHide = new HashSet<ResourceLocation>();
        for (ResourceLocation item : itemsByTag) {
            if (replacements.contains(item)) continue;
            itemsToHide.add(item);
        }
        if (itemsToHide.isEmpty()) {
            return null;
        }
        AlmostUnified.LOG.info("[AutoHiding] Hiding {}/{} items for tag '#{}' -> {}", (Object)itemsToHide.size(), (Object)itemsByTag.size(), (Object)unifyTag.location(), itemsToHide);
        return itemsToHide;
    }

    private static Set<ResourceLocation> getRefItemsToHide(UnifyTag<Item> unifyTag, TagOwnerships ownerships, Set<ResourceLocation> replacements) {
        Collection<UnifyTag<Item>> refTags = ownerships.getRefsByOwner(unifyTag);
        HashSet<ResourceLocation> refItemsToHide = new HashSet<ResourceLocation>();
        for (UnifyTag<Item> refTag : refTags) {
            TagKey asTagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)refTag.location());
            BuiltInRegistries.f_257033_.m_206058_(asTagKey).forEach(holder -> {
                ResourceLocation item = BuiltInRegistries.f_257033_.m_7981_((Object)((Item)holder.m_203334_()));
                if (replacements.contains(item)) {
                    return;
                }
                refItemsToHide.add(item);
            });
            if (refItemsToHide.isEmpty()) continue;
            AlmostUnified.LOG.info("[AutoHiding] Hiding reference tag '#{}' of owner tag '#{}' -> {}", (Object)refTag.location(), (Object)unifyTag.location(), refItemsToHide);
        }
        return refItemsToHide;
    }

    public static Collection<ItemStack> getStacksToHide() {
        Multimap<UnifyTag<Item>, ResourceLocation> hidingMap = HideHelper.createHidingMap();
        if (hidingMap.isEmpty()) {
            return List.of();
        }
        return hidingMap.entries().stream().flatMap(rl -> BuiltInRegistries.f_257033_.m_6612_((ResourceLocation)rl.getValue()).stream()).map(ItemStack::new).toList();
    }
}

