/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.api.recipe.RecipeContext;
import com.almostreliable.unified.api.recipe.RecipeUnifier;
import com.almostreliable.unified.api.recipe.RecipeUnifierBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nullable;

public class IntegratedDynamicsRecipeUnifier
implements RecipeUnifier {
    private static final String ITEMS = "items";

    @Override
    public void collectUnifier(RecipeUnifierBuilder builder) {
        builder.put("item", this::createItemReplacement);
        builder.put("result", this::createResultReplacement);
    }

    @Nullable
    private JsonElement createItemReplacement(@Nullable JsonElement json, RecipeContext ctx) {
        if (json instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)json;
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("item", (JsonElement)jsonPrimitive);
            return ctx.createIngredientReplacement((JsonElement)jsonObject);
        }
        return ctx.createIngredientReplacement(json);
    }

    @Nullable
    private JsonElement createResultReplacement(@Nullable JsonElement json, RecipeContext ctx) {
        JsonElement resultReplacement;
        JsonObject jsonObject;
        if (json instanceof JsonObject && (jsonObject = (JsonObject)json).has(ITEMS) && (resultReplacement = ctx.createResultReplacement(jsonObject.get(ITEMS))) != null) {
            jsonObject.add(ITEMS, resultReplacement);
            return jsonObject;
        }
        return null;
    }
}

