/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import com.nosiphus.furniture.blockentity.ChoppingBoardBlockEntity;
import com.nosiphus.furniture.core.ModItems;
import com.nosiphus.furniture.item.crafting.ChoppingRecipe;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChoppingBoardBlock
extends FurnitureHorizontalBlock
implements EntityBlock {
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public ChoppingBoardBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.EAST));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] CHOPPING_BOARD = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)0.5, (double)13.0, (double)1.0, (double)15.5), (Direction)Direction.EAST));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(CHOPPING_BOARD[direction.m_122416_()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ChoppingBoardBlockEntity) {
                ChoppingBoardBlockEntity blockEntity2 = (ChoppingBoardBlockEntity)blockEntity;
                Containers.m_19010_((Level)level, (BlockPos)pos, blockEntity2.getChoppingBoard());
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && result.m_82434_() == Direction.UP && (blockEntity = level.m_7702_(pos)) instanceof ChoppingBoardBlockEntity) {
            ChoppingBoardBlockEntity blockEntity2 = (ChoppingBoardBlockEntity)blockEntity;
            ItemStack heldItem = player.m_21120_(hand);
            if (heldItem.m_41720_() == ModItems.KNIFE.get()) {
                if (blockEntity2.chopItem() && !player.m_150110_().f_35937_) {
                    heldItem.m_41721_(heldItem.m_41773_() + 1);
                }
            } else if (!heldItem.m_41619_()) {
                Optional<ChoppingRecipe> optional = blockEntity2.findMatchingRecipe(heldItem);
                if (optional.isPresent()) {
                    if (blockEntity2.addItem(heldItem) && !player.m_150110_().f_35937_) {
                        heldItem.m_41774_(1);
                    }
                } else if (!level.m_5776_()) {
                    blockEntity2.removeItem();
                }
            } else {
                blockEntity2.removeItem();
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ChoppingBoardBlockEntity(pos, state);
    }
}

