/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CurtainBlock
extends FurnitureHorizontalBlock {
    public static final BooleanProperty CLOSED = BooleanProperty.m_61465_((String)"closed");
    public static final BooleanProperty LEFT_CLOSED = BooleanProperty.m_61465_((String)"left_closed");
    public static final BooleanProperty LEFT_EXISTS = BooleanProperty.m_61465_((String)"left_exists");
    public static final BooleanProperty RIGHT_CLOSED = BooleanProperty.m_61465_((String)"right_closed");
    public static final BooleanProperty RIGHT_EXISTS = BooleanProperty.m_61465_((String)"right_exists");
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public CurtainBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.SOUTH)).m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] ROD = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)14.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (Direction)Direction.EAST));
        VoxelShape[] CURTAIN_AREA_OPEN = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)15.0, (double)2.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), (Direction)Direction.EAST));
        VoxelShape[] CURTAIN_AREA_CLOSED = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), (Direction)Direction.EAST));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            boolean closed = (Boolean)state.m_61143_((Property)CLOSED);
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(ROD[direction.m_122416_()]);
            if (closed) {
                shapes.add(CURTAIN_AREA_CLOSED[direction.m_122416_()]);
            } else {
                shapes.add(CURTAIN_AREA_OPEN[direction.m_122416_()]);
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return this.getCurtainState(state, (LevelAccessor)context.m_43725_(), context.m_8083_(), (Direction)state.m_61143_((Property)DIRECTION));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player playerEntity, InteractionHand hand, BlockHitResult result) {
        if (((Boolean)state.m_61143_((Property)CLOSED)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(false)), 2);
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(true)), 2);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.getCurtainState(state, level, pos, (Direction)state.m_61143_((Property)DIRECTION));
    }

    private BlockState getCurtainState(BlockState state, LevelAccessor level, BlockPos pos, Direction dir) {
        BlockState rightState;
        boolean leftClosed = false;
        boolean leftExists = false;
        boolean rightClosed = false;
        boolean rightExists = false;
        boolean closed = (Boolean)state.m_61143_((Property)CLOSED);
        BlockState leftState = level.m_8055_(pos.m_121945_(dir.m_175364_(Direction.Axis.Y)));
        if (leftState.m_60734_() instanceof CurtainBlock) {
            leftExists = true;
            if (((Boolean)leftState.m_61143_((Property)CLOSED)).booleanValue()) {
                leftClosed = true;
            }
        }
        if ((rightState = level.m_8055_(pos.m_121945_(dir.m_175362_(Direction.Axis.Y)))).m_60734_() instanceof CurtainBlock) {
            rightExists = true;
            if (((Boolean)rightState.m_61143_((Property)CLOSED)).booleanValue()) {
                rightClosed = true;
            }
        }
        if (closed && leftClosed && leftExists && rightClosed && rightExists) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(true));
        }
        if (!closed && leftClosed && leftExists && rightClosed && rightExists) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(true));
        }
        if (closed && !leftClosed && leftExists && rightClosed && rightExists) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(true));
        }
        if (!closed && !leftClosed && leftExists && rightClosed && rightExists) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(true));
        }
        if (closed && leftClosed && leftExists && !rightClosed && rightExists) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(true));
        }
        if (!closed && leftClosed && leftExists && !rightClosed && rightExists) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(true));
        }
        if (closed && !leftClosed && leftExists && !rightClosed && rightExists) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(true));
        }
        if (!closed && !leftClosed && leftExists && !rightClosed && rightExists) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(true));
        }
        if (closed && !leftClosed && !leftExists && rightClosed && rightExists) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(true));
        }
        if (!closed && !leftClosed && !leftExists && rightClosed && rightExists) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(true));
        }
        if (closed && !leftClosed && !leftExists && !rightClosed && rightExists) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(true));
        }
        if (!(closed || leftClosed || leftExists || rightClosed || !rightExists)) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(true));
        }
        if (closed && leftClosed && leftExists && !rightClosed && !rightExists) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(false));
        }
        if (!closed && leftClosed && leftExists && !rightClosed && !rightExists) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(false));
        }
        if (closed && !leftClosed && leftExists && !rightClosed && !rightExists) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(false));
        }
        if (!(closed || leftClosed || !leftExists || rightClosed || rightExists)) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(false));
        }
        if (!(!closed || leftClosed || leftExists || rightClosed || rightExists)) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(false));
        }
        if (!(closed || leftClosed || leftExists || rightClosed || rightExists)) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT_EXISTS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_CLOSED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_EXISTS, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CLOSED});
        builder.m_61104_(new Property[]{LEFT_CLOSED});
        builder.m_61104_(new Property[]{LEFT_EXISTS});
        builder.m_61104_(new Property[]{RIGHT_CLOSED});
        builder.m_61104_(new Property[]{RIGHT_EXISTS});
    }
}

