/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import com.nosiphus.furniture.common.ModDamageTypes;
import com.nosiphus.furniture.core.ModSounds;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ElectricFenceBlock
extends FenceBlock {
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public ElectricFenceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_52309_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52310_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52311_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52312_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_52313_, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape POST = Block.m_49796_((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5);
        VoxelShape NORTH_SIDE = Block.m_49796_((double)7.3, (double)0.0, (double)0.0, (double)8.7, (double)16.0, (double)8.0);
        VoxelShape EAST_SIDE = Block.m_49796_((double)8.0, (double)0.0, (double)7.3, (double)16.0, (double)16.0, (double)8.7);
        VoxelShape SOUTH_SIDE = Block.m_49796_((double)7.3, (double)0.0, (double)8.0, (double)8.7, (double)16.0, (double)16.0);
        VoxelShape WEST_SIDE = Block.m_49796_((double)0.0, (double)0.0, (double)7.3, (double)8.0, (double)16.0, (double)8.7);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            boolean north = (Boolean)state.m_61143_((Property)f_52309_);
            boolean east = (Boolean)state.m_61143_((Property)f_52310_);
            boolean south = (Boolean)state.m_61143_((Property)f_52311_);
            boolean west = (Boolean)state.m_61143_((Property)f_52312_);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(POST);
            if (north) {
                shapes.add(NORTH_SIDE);
            }
            if (east) {
                shapes.add(EAST_SIDE);
            }
            if (south) {
                shapes.add(SOUTH_SIDE);
            }
            if (west) {
                shapes.add(WEST_SIDE);
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity && !((LivingEntity)entity).m_21224_()) {
            if (entity instanceof Creeper) {
                Creeper creeper = (Creeper)entity;
                LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
                level.m_7967_((Entity)lightningBolt);
                if (!creeper.m_7090_()) {
                    creeper.m_20254_(1);
                    creeper.m_8038_((ServerLevel)level, lightningBolt);
                }
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!player.m_7500_()) {
                    player.m_6469_(level.m_269111_().m_269079_(ModDamageTypes.ELECTRIC_FENCE), 2.0f);
                    level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)ModSounds.BLOCK_ELECTRIC_FENCE_ZAP.get(), SoundSource.BLOCKS, 0.2f, 1.0f);
                }
            } else {
                entity.m_6469_(level.m_269111_().m_269079_(ModDamageTypes.ELECTRIC_FENCE), 2.0f);
                level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)ModSounds.BLOCK_ELECTRIC_FENCE_ZAP.get(), SoundSource.BLOCKS, 0.2f, 1.0f);
            }
        }
    }
}

