/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureBlock;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LampBlock
extends FurnitureBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public LampBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(TYPE, (Comparable)((Object)Type.SINGLE))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Type type = (Type)((Object)state.m_61143_(TYPE));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            switch (type) {
                case SINGLE: {
                    shapes.add(Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0));
                    shapes.add(Block.m_49796_((double)7.0, (double)9.5, (double)7.0, (double)9.0, (double)12.5, (double)9.0));
                    shapes.add(Block.m_49796_((double)1.5, (double)8.0, (double)1.5, (double)14.5, (double)15.0, (double)14.5));
                    shapes.add(Block.m_49796_((double)7.2, (double)5.0, (double)7.2, (double)8.8, (double)9.6, (double)8.8));
                    break;
                }
                case TOP: {
                    shapes.add(Block.m_49796_((double)7.0, (double)9.5, (double)7.0, (double)9.0, (double)12.5, (double)9.0));
                    shapes.add(Block.m_49796_((double)1.5, (double)8.0, (double)1.5, (double)14.5, (double)15.0, (double)14.5));
                    shapes.add(Block.m_49796_((double)7.2, (double)0.0, (double)7.2, (double)8.8, (double)9.6, (double)8.8));
                    break;
                }
                case MIDDLE: {
                    shapes.add(Block.m_49796_((double)7.2, (double)0.0, (double)7.2, (double)8.8, (double)16.0, (double)8.8));
                    break;
                }
                case BOTTOM: {
                    shapes.add(Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0));
                    shapes.add(Block.m_49796_((double)7.2, (double)2.0, (double)7.2, (double)8.8, (double)16.0, (double)8.8));
                }
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player playerEntity, InteractionHand hand, BlockHitResult result) {
        if (level.m_8055_(pos.m_7494_()).m_60734_() instanceof LampBlock) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        } else if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.getLampState(state, level, pos);
    }

    private BlockState getLampState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean top = false;
        BlockState upState = level.m_8055_(pos.m_7494_());
        if (upState.m_60734_() instanceof LampBlock) {
            top = true;
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        }
        boolean bottom = false;
        BlockState downState = level.m_8055_(pos.m_7495_());
        if (downState.m_60734_() instanceof LampBlock) {
            bottom = true;
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        }
        if (top && bottom) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.MIDDLE));
        }
        if (bottom) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.TOP));
        }
        if (top) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.BOTTOM));
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.SINGLE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TYPE});
        builder.m_61104_(new Property[]{LIT});
    }

    public static enum Type implements StringRepresentable
    {
        SINGLE("single"),
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String id;

        private Type(String id) {
            this.id = id;
        }

        public String m_7912_() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }
    }
}

