/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.tileentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.tileentity.DeskCabinetBlockEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import com.nosiphus.furniture.block.ModernDeskBlock;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModernDeskCabinetBlock
extends ModernDeskBlock
implements EntityBlock {
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");

    public ModernDeskCabinetBlock(BlockBehaviour.Properties properties, ModernDeskBlock.MaterialType materialType) {
        super(properties, materialType);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_((Property)TYPE, (Comparable)((Object)ModernDeskBlock.Type.SINGLE))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] DESK_TOP = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (Direction)Direction.SOUTH));
        VoxelShape[] DESK_BACK = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)1.0, (double)16.0, (double)14.0, (double)3.0), (Direction)Direction.SOUTH));
        VoxelShape[] DESK_LEFT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0), (Direction)Direction.SOUTH));
        VoxelShape[] DESK_RIGHT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)15.0), (Direction)Direction.SOUTH));
        VoxelShape[] DESK_DRAWS = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)2.0, (double)3.0, (double)14.0, (double)14.0, (double)15.0), (Direction)Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            ModernDeskBlock.Type type = (ModernDeskBlock.Type)((Object)state.m_61143_((Property)TYPE));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(DESK_TOP[direction.m_122416_()]);
            shapes.add(DESK_BACK[direction.m_122416_()]);
            shapes.add(DESK_DRAWS[direction.m_122416_()]);
            switch (type) {
                case SINGLE: {
                    shapes.add(DESK_LEFT[direction.m_122416_()]);
                    shapes.add(DESK_RIGHT[direction.m_122416_()]);
                    break;
                }
                case LEFT: {
                    shapes.add(DESK_LEFT[direction.m_122416_()]);
                    break;
                }
                case RIGHT: {
                    shapes.add(DESK_RIGHT[direction.m_122416_()]);
                }
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (((Direction)state.m_61143_((Property)DIRECTION)).m_122424_() == result.m_82434_()) {
            BlockEntity blockEntity;
            if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof DeskCabinetBlockEntity) {
                DeskCabinetBlockEntity blockEntity2 = (DeskCabinetBlockEntity)blockEntity;
                player.m_5893_((MenuProvider)blockEntity2);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BasicLootBlockEntity) {
            BasicLootBlockEntity blockEntity2 = (BasicLootBlockEntity)blockEntity;
            blockEntity2.updateOpenerCount();
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{OPEN});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DeskCabinetBlockEntity(pos, state);
    }
}

