/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.entity.SeatEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModernSofaBlock
extends FurnitureHorizontalBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public ModernSofaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)Type.SINGLE)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] BACKBASE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)5.0, (double)1.0, (double)14.0, (double)19.0, (double)2.0), (Direction)Direction.SOUTH));
        VoxelShape[] LEFT_BACKBASE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)14.0, (double)5.0, (double)1.0, (double)16.0, (double)19.0, (double)2.0), (Direction)Direction.SOUTH));
        VoxelShape[] RIGHT_BACKBASE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)5.0, (double)1.0, (double)2.0, (double)19.0, (double)2.0), (Direction)Direction.SOUTH));
        VoxelShape[] BASE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)5.0, (double)2.0, (double)14.0, (double)9.0, (double)15.0), (Direction)Direction.SOUTH));
        VoxelShape[] LEFT_BASE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)14.0, (double)5.0, (double)2.0, (double)16.0, (double)9.0, (double)15.0), (Direction)Direction.SOUTH));
        VoxelShape[] RIGHT_BASE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)5.0, (double)2.0, (double)2.0, (double)9.0, (double)15.0), (Direction)Direction.SOUTH));
        VoxelShape[] UNDERBASE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)3.0, (double)1.0, (double)14.0, (double)5.0, (double)15.0), (Direction)Direction.SOUTH));
        VoxelShape[] LEFT_UNDERBASE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)14.0, (double)3.0, (double)1.0, (double)16.0, (double)5.0, (double)15.0), (Direction)Direction.SOUTH));
        VoxelShape[] RIGHT_UNDERBASE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)3.0, (double)1.0, (double)2.0, (double)5.0, (double)15.0), (Direction)Direction.SOUTH));
        VoxelShape[] BACKREST = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)9.0, (double)2.0, (double)14.0, (double)19.0, (double)5.0), (Direction)Direction.SOUTH));
        VoxelShape[] LEFT_BACKREST = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)14.0, (double)9.0, (double)2.0, (double)16.0, (double)19.0, (double)5.0), (Direction)Direction.SOUTH));
        VoxelShape[] RIGHT_BACKREST = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)9.0, (double)2.0, (double)2.0, (double)19.0, (double)5.0), (Direction)Direction.SOUTH));
        VoxelShape[] LEFT_ARM_TOP = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)11.0, (double)1.0, (double)2.0, (double)13.0, (double)15.0), (Direction)Direction.SOUTH));
        VoxelShape[] LEFT_ARM_FRONT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)13.0, (double)2.0, (double)11.0, (double)15.0), (Direction)Direction.SOUTH));
        VoxelShape[] LEFT_ARM_BACK = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)1.0, (double)2.0, (double)11.0, (double)3.0), (Direction)Direction.SOUTH));
        VoxelShape[] LEFT_ARM_BOTTOM = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)2.0, (double)2.0, (double)15.0), (Direction)Direction.SOUTH));
        VoxelShape[] RIGHT_ARM_TOP = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)14.0, (double)11.0, (double)1.0, (double)16.0, (double)13.0, (double)15.0), (Direction)Direction.SOUTH));
        VoxelShape[] RIGHT_ARM_FRONT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)14.0, (double)2.0, (double)13.0, (double)16.0, (double)11.0, (double)15.0), (Direction)Direction.SOUTH));
        VoxelShape[] RIGHT_ARM_BACK = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)14.0, (double)2.0, (double)1.0, (double)16.0, (double)11.0, (double)3.0), (Direction)Direction.SOUTH));
        VoxelShape[] RIGHT_ARM_BOTTOM = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)14.0, (double)0.0, (double)1.0, (double)16.0, (double)2.0, (double)15.0), (Direction)Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            Type type = (Type)((Object)state.m_61143_(TYPE));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(BASE[direction.m_122416_()]);
            shapes.add(BACKREST[direction.m_122416_()]);
            shapes.add(BACKBASE[direction.m_122416_()]);
            shapes.add(UNDERBASE[direction.m_122416_()]);
            switch (type) {
                case SINGLE: {
                    shapes.add(LEFT_ARM_TOP[direction.m_122416_()]);
                    shapes.add(LEFT_ARM_FRONT[direction.m_122416_()]);
                    shapes.add(LEFT_ARM_BACK[direction.m_122416_()]);
                    shapes.add(LEFT_ARM_BOTTOM[direction.m_122416_()]);
                    shapes.add(RIGHT_ARM_TOP[direction.m_122416_()]);
                    shapes.add(RIGHT_ARM_FRONT[direction.m_122416_()]);
                    shapes.add(RIGHT_ARM_BACK[direction.m_122416_()]);
                    shapes.add(RIGHT_ARM_BOTTOM[direction.m_122416_()]);
                    break;
                }
                case LEFT: {
                    shapes.add(LEFT_ARM_TOP[direction.m_122416_()]);
                    shapes.add(LEFT_ARM_FRONT[direction.m_122416_()]);
                    shapes.add(LEFT_ARM_BACK[direction.m_122416_()]);
                    shapes.add(LEFT_ARM_BOTTOM[direction.m_122416_()]);
                    shapes.add(LEFT_BACKREST[direction.m_122416_()]);
                    shapes.add(LEFT_BASE[direction.m_122416_()]);
                    shapes.add(LEFT_BACKBASE[direction.m_122416_()]);
                    shapes.add(LEFT_UNDERBASE[direction.m_122416_()]);
                    break;
                }
                case RIGHT: {
                    shapes.add(RIGHT_ARM_TOP[direction.m_122416_()]);
                    shapes.add(RIGHT_ARM_FRONT[direction.m_122416_()]);
                    shapes.add(RIGHT_ARM_BACK[direction.m_122416_()]);
                    shapes.add(RIGHT_ARM_BOTTOM[direction.m_122416_()]);
                    shapes.add(RIGHT_BACKREST[direction.m_122416_()]);
                    shapes.add(RIGHT_BASE[direction.m_122416_()]);
                    shapes.add(RIGHT_BACKBASE[direction.m_122416_()]);
                    shapes.add(RIGHT_UNDERBASE[direction.m_122416_()]);
                    break;
                }
                case MIDDLE: {
                    shapes.add(LEFT_BACKREST[direction.m_122416_()]);
                    shapes.add(LEFT_BASE[direction.m_122416_()]);
                    shapes.add(LEFT_BACKBASE[direction.m_122416_()]);
                    shapes.add(LEFT_UNDERBASE[direction.m_122416_()]);
                    shapes.add(RIGHT_BACKREST[direction.m_122416_()]);
                    shapes.add(RIGHT_BASE[direction.m_122416_()]);
                    shapes.add(RIGHT_BACKBASE[direction.m_122416_()]);
                    shapes.add(RIGHT_UNDERBASE[direction.m_122416_()]);
                }
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return this.getSofaState(state, (LevelAccessor)context.m_43725_(), context.m_8083_(), (Direction)state.m_61143_((Property)DIRECTION));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player playerEntity, InteractionHand hand, BlockHitResult result) {
        if (!level.m_5776_()) {
            ItemStack stack = playerEntity.m_21120_(hand);
            return SeatEntity.create((Level)level, (BlockPos)pos, (double)0.4, (Player)playerEntity, (Direction)((Direction)state.m_61143_((Property)DIRECTION)));
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.getSofaState(state, level, pos, (Direction)state.m_61143_((Property)DIRECTION));
    }

    private BlockState getSofaState(BlockState state, LevelAccessor level, BlockPos pos, Direction dir) {
        boolean right;
        boolean left = this.isSofa(level, pos, dir.m_122428_(), dir) || this.isSofa(level, pos, dir.m_122428_(), dir.m_122428_());
        boolean bl = right = this.isSofa(level, pos, dir.m_122427_(), dir) || this.isSofa(level, pos, dir.m_122427_(), dir.m_122427_());
        if (left && right) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.MIDDLE));
        }
        if (left) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.RIGHT));
        }
        if (right) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.LEFT));
        }
        return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.SINGLE));
    }

    private boolean isSofa(LevelAccessor level, BlockPos source, Direction direction, Direction targetDirection) {
        BlockState state = level.m_8055_(source.m_121945_(direction));
        if (state.m_60734_() == this) {
            Direction sofaDirection = (Direction)state.m_61143_((Property)DIRECTION);
            return sofaDirection.equals((Object)targetDirection);
        }
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TYPE});
    }

    public static enum Type implements StringRepresentable
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle");

        private final String id;

        private Type(String id) {
            this.id = id;
        }

        public String m_7912_() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }
    }
}

