/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureWaterloggedBlock;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModernTableBlock
extends FurnitureWaterloggedBlock {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public ModernTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape TABLE_TOP = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape LEG_SOUTH_EAST = Block.m_49796_((double)13.5, (double)0.0, (double)13.5, (double)15.0, (double)14.0, (double)15.0);
        VoxelShape LEG_SOUTH_WEST = Block.m_49796_((double)1.0, (double)0.0, (double)13.5, (double)2.5, (double)14.0, (double)15.0);
        VoxelShape LEG_NORTH_EAST = Block.m_49796_((double)13.5, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)2.5);
        VoxelShape LEG_NORTH_WEST = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)2.5, (double)14.0, (double)2.5);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            boolean north = (Boolean)state.m_61143_((Property)NORTH);
            boolean east = (Boolean)state.m_61143_((Property)EAST);
            boolean south = (Boolean)state.m_61143_((Property)SOUTH);
            boolean west = (Boolean)state.m_61143_((Property)WEST);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(TABLE_TOP);
            if (!north && !west) {
                shapes.add(LEG_NORTH_WEST);
            }
            if (!north && !east) {
                shapes.add(LEG_NORTH_EAST);
            }
            if (!south && !west) {
                shapes.add(LEG_SOUTH_WEST);
            }
            if (!south && !east) {
                shapes.add(LEG_SOUTH_EAST);
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        boolean north = level.m_8055_(pos.m_122012_()).m_60734_() == this;
        boolean east = level.m_8055_(pos.m_122029_()).m_60734_() == this;
        boolean south = level.m_8055_(pos.m_122019_()).m_60734_() == this;
        boolean west = level.m_8055_(pos.m_122024_()).m_60734_() == this;
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH});
        builder.m_61104_(new Property[]{EAST});
        builder.m_61104_(new Property[]{SOUTH});
        builder.m_61104_(new Property[]{WEST});
    }
}

