/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.util.BlockEntityUtil;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import com.nosiphus.furniture.blockentity.StereoBlockEntity;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;

public class StereoBlock
extends FurnitureHorizontalBlock
implements EntityBlock {
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;
    public static ArrayList<RecordItem> records = new ArrayList();

    public StereoBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.EAST));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
        for (Item item : ForgeRegistries.ITEMS) {
            if (!(item instanceof RecordItem)) continue;
            records.add((RecordItem)item);
        }
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] CORE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)5.5, (double)0.0, (double)0.5, (double)10.5, (double)7.0, (double)15.5), (Direction)Direction.EAST));
        VoxelShape[] SCREEN = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)5.4, (double)3.0, (double)5.6, (double)5.5, (double)6.0, (double)10.6), (Direction)Direction.EAST));
        VoxelShape[] ANTENNA_BASE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)7.0, (double)7.0, (double)6.2, (double)9.0, (double)7.5, (double)9.8), (Direction)Direction.EAST));
        VoxelShape[] POWER_BUTTON = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)5.1, (double)1.0, (double)6.0, (double)5.5, (double)2.0, (double)7.0), (Direction)Direction.EAST));
        VoxelShape[] BUTTON_1 = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)5.1, (double)1.0, (double)7.5, (double)5.5, (double)2.0, (double)8.5), (Direction)Direction.EAST));
        VoxelShape[] BUTTON_2 = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)5.1, (double)1.0, (double)9.0, (double)5.5, (double)2.0, (double)10.0), (Direction)Direction.EAST));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(CORE[direction.m_122416_()]);
            shapes.add(SCREEN[direction.m_122416_()]);
            shapes.add(ANTENNA_BASE[direction.m_122416_()]);
            shapes.add(POWER_BUTTON[direction.m_122416_()]);
            shapes.add(BUTTON_1[direction.m_122416_()]);
            shapes.add(BUTTON_2[direction.m_122416_()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof StereoBlockEntity) {
            StereoBlockEntity stereoBlockEntity = (StereoBlockEntity)blockEntity;
            if (!player.m_20161_()) {
                stereoBlockEntity.count = stereoBlockEntity.count == records.size() ? records.size() : ++stereoBlockEntity.count;
                if (stereoBlockEntity.count == records.size()) {
                    stereoBlockEntity.count = 0;
                }
                level.m_46796_(1010, pos, Item.m_41393_((Item)((Item)records.get(stereoBlockEntity.count))));
            } else if (stereoBlockEntity.count != records.size()) {
                stereoBlockEntity.count = records.size();
                if (!level.m_5776_()) {
                    // empty if block
                }
                this.ejectRecord(level, pos);
            }
            if (!level.m_5776_()) {
                BlockEntityUtil.sendUpdatePacket((BlockEntity)blockEntity);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        this.ejectRecord(level, pos);
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void ejectRecord(Level level, BlockPos pos) {
        level.m_46796_(1011, pos, -1);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new StereoBlockEntity(pos, state);
    }
}

