/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.tileentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.tileentity.CabinetBlockEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TelevisionStandBlock
extends FurnitureHorizontalBlock
implements EntityBlock {
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public TelevisionStandBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)Type.SINGLE))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] TABLE_TOP = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)14.5, (double)1.0, (double)16.0, (double)16.0, (double)15.0), (Direction)Direction.SOUTH));
        VoxelShape[] NORTHWEST_LEG = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)2.0, (double)2.5, (double)3.5, (double)3.5), (Direction)Direction.SOUTH));
        VoxelShape[] NORTHEAST_LEG = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)13.5, (double)0.0, (double)2.0, (double)15.0, (double)3.5, (double)3.5), (Direction)Direction.SOUTH));
        VoxelShape[] SOUTHWEST_LEG = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)12.5, (double)2.5, (double)3.5, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] SOUTHEAST_LEG = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)13.5, (double)0.0, (double)12.5, (double)15.0, (double)3.5, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] LEFT_SIDE_SINGLE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)5.0, (double)2.0, (double)2.5, (double)14.5, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] RIGHT_SIDE_SINGLE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)13.5, (double)5.0, (double)2.0, (double)15.0, (double)14.5, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] BACK_SIDE_SINGLE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.5, (double)5.0, (double)2.0, (double)13.5, (double)14.5, (double)3.5), (Direction)Direction.SOUTH));
        VoxelShape[] TOP_SHELF_SINGLE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.5, (double)9.0, (double)3.5, (double)13.5, (double)10.5, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] BOTTOM_SHELF_SINGLE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)3.5, (double)2.0, (double)15.0, (double)5.0, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] LEFT_SIDE_LEFT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)5.0, (double)2.0, (double)2.5, (double)14.5, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] RIGHT_SIDE_LEFT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)14.5, (double)5.0, (double)2.0, (double)16.0, (double)14.5, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] BACK_SIDE_LEFT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.5, (double)5.0, (double)2.0, (double)14.5, (double)14.5, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] BOTTOM_SHELF_LEFT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)3.5, (double)2.0, (double)16.0, (double)5.0, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] DOOR_LEFT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.5, (double)5.0, (double)13.5, (double)15.0, (double)14.0, (double)14.5), (Direction)Direction.SOUTH));
        VoxelShape[] DOOR_HANDLE_TOP_LEFT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)13.0, (double)11.0, (double)14.5, (double)14.0, (double)12.0, (double)15.0), (Direction)Direction.SOUTH));
        VoxelShape[] DOOR_HANDLE_LEFT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)13.0, (double)7.0, (double)15.0, (double)14.0, (double)12.0, (double)15.5), (Direction)Direction.SOUTH));
        VoxelShape[] DOOR_HANDLE_BOTTOM_LEFT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)13.0, (double)7.0, (double)14.5, (double)14.0, (double)8.0, (double)15.0), (Direction)Direction.SOUTH));
        VoxelShape[] LEFT_SIDE_RIGHT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)5.0, (double)2.0, (double)1.5, (double)14.5, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] RIGHT_SIDE_RIGHT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)13.5, (double)5.0, (double)2.0, (double)15.0, (double)14.5, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] BACK_SIDE_RIGHT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.5, (double)5.0, (double)2.0, (double)13.5, (double)14.5, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] BOTTOM_SHELF_RIGHT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)3.5, (double)2.0, (double)15.0, (double)5.0, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] DOOR_RIGHT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)1.0, (double)5.0, (double)13.5, (double)13.5, (double)14.0, (double)14.5), (Direction)Direction.SOUTH));
        VoxelShape[] DOOR_HANDLE_TOP_RIGHT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)11.0, (double)14.5, (double)3.0, (double)12.0, (double)15.0), (Direction)Direction.SOUTH));
        VoxelShape[] DOOR_HANDLE_RIGHT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)7.0, (double)15.0, (double)3.0, (double)12.0, (double)15.5), (Direction)Direction.SOUTH));
        VoxelShape[] DOOR_HANDLE_BOTTOM_RIGHT = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)2.0, (double)7.0, (double)14.5, (double)3.0, (double)8.0, (double)15.0), (Direction)Direction.SOUTH));
        VoxelShape[] LEFT_SIDE_MIDDLE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)5.0, (double)2.0, (double)0.5, (double)14.5, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] RIGHT_SIDE_MIDDLE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)15.5, (double)5.0, (double)2.0, (double)16.0, (double)14.5, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] BACK_SIDE_MIDDLE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.5, (double)5.0, (double)2.0, (double)15.5, (double)14.5, (double)3.5), (Direction)Direction.SOUTH));
        VoxelShape[] TOP_SHELF_MIDDLE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.5, (double)9.0, (double)3.5, (double)15.5, (double)10.5, (double)14.0), (Direction)Direction.SOUTH));
        VoxelShape[] BOTTOM_SHELF_MIDDLE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)0.0, (double)3.5, (double)2.0, (double)16.0, (double)5.0, (double)14.0), (Direction)Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            Type type = (Type)((Object)state.m_61143_(TYPE));
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(TABLE_TOP[direction.m_122416_()]);
            switch (type) {
                case SINGLE: {
                    shapes.add(NORTHWEST_LEG[direction.m_122416_()]);
                    shapes.add(NORTHEAST_LEG[direction.m_122416_()]);
                    shapes.add(SOUTHWEST_LEG[direction.m_122416_()]);
                    shapes.add(SOUTHEAST_LEG[direction.m_122416_()]);
                    shapes.add(LEFT_SIDE_SINGLE[direction.m_122416_()]);
                    shapes.add(RIGHT_SIDE_SINGLE[direction.m_122416_()]);
                    shapes.add(BACK_SIDE_SINGLE[direction.m_122416_()]);
                    shapes.add(TOP_SHELF_SINGLE[direction.m_122416_()]);
                    shapes.add(BOTTOM_SHELF_SINGLE[direction.m_122416_()]);
                    break;
                }
                case LEFT: {
                    shapes.add(NORTHWEST_LEG[direction.m_122416_()]);
                    shapes.add(SOUTHWEST_LEG[direction.m_122416_()]);
                    shapes.add(LEFT_SIDE_LEFT[direction.m_122416_()]);
                    shapes.add(RIGHT_SIDE_LEFT[direction.m_122416_()]);
                    shapes.add(BACK_SIDE_LEFT[direction.m_122416_()]);
                    shapes.add(BOTTOM_SHELF_LEFT[direction.m_122416_()]);
                    shapes.add(DOOR_LEFT[direction.m_122416_()]);
                    shapes.add(DOOR_HANDLE_TOP_LEFT[direction.m_122416_()]);
                    shapes.add(DOOR_HANDLE_LEFT[direction.m_122416_()]);
                    shapes.add(DOOR_HANDLE_BOTTOM_LEFT[direction.m_122416_()]);
                    break;
                }
                case RIGHT: {
                    shapes.add(NORTHEAST_LEG[direction.m_122416_()]);
                    shapes.add(SOUTHEAST_LEG[direction.m_122416_()]);
                    shapes.add(LEFT_SIDE_RIGHT[direction.m_122416_()]);
                    shapes.add(RIGHT_SIDE_RIGHT[direction.m_122416_()]);
                    shapes.add(BACK_SIDE_RIGHT[direction.m_122416_()]);
                    shapes.add(BOTTOM_SHELF_RIGHT[direction.m_122416_()]);
                    shapes.add(DOOR_RIGHT[direction.m_122416_()]);
                    shapes.add(DOOR_HANDLE_TOP_RIGHT[direction.m_122416_()]);
                    shapes.add(DOOR_HANDLE_RIGHT[direction.m_122416_()]);
                    shapes.add(DOOR_HANDLE_BOTTOM_RIGHT[direction.m_122416_()]);
                    break;
                }
                case MIDDLE: {
                    shapes.add(LEFT_SIDE_MIDDLE[direction.m_122416_()]);
                    shapes.add(RIGHT_SIDE_MIDDLE[direction.m_122416_()]);
                    shapes.add(BACK_SIDE_MIDDLE[direction.m_122416_()]);
                    shapes.add(TOP_SHELF_MIDDLE[direction.m_122416_()]);
                    shapes.add(BOTTOM_SHELF_MIDDLE[direction.m_122416_()]);
                }
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return this.getTVStandState(state, (LevelAccessor)context.m_43725_(), context.m_8083_(), (Direction)state.m_61143_((Property)DIRECTION));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.getTVStandState(state, level, pos, (Direction)state.m_61143_((Property)DIRECTION));
    }

    private BlockState getTVStandState(BlockState state, LevelAccessor level, BlockPos pos, Direction dir) {
        boolean right;
        boolean left = this.isTVStand(level, pos, dir.m_122428_(), dir) || this.isTVStand(level, pos, dir.m_122428_(), dir.m_122428_());
        boolean bl = right = this.isTVStand(level, pos, dir.m_122427_(), dir) || this.isTVStand(level, pos, dir.m_122427_(), dir.m_122427_());
        if (left && right) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.MIDDLE));
        }
        if (left) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.RIGHT));
        }
        if (right) {
            return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.LEFT));
        }
        return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)Type.SINGLE));
    }

    private boolean isTVStand(LevelAccessor level, BlockPos source, Direction direction, Direction targetDirection) {
        BlockState state = level.m_8055_(source.m_121945_(direction));
        if (state.m_60734_() == this) {
            Direction tvStandDirection = (Direction)state.m_61143_((Property)DIRECTION);
            return tvStandDirection.equals((Object)targetDirection);
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (((Direction)state.m_61143_((Property)DIRECTION)).m_122424_() == result.m_82434_()) {
            BlockEntity blockEntity;
            if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof CabinetBlockEntity) {
                CabinetBlockEntity blockEntity2 = (CabinetBlockEntity)blockEntity;
                player.m_5893_((MenuProvider)blockEntity2);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BasicLootBlockEntity) {
            BasicLootBlockEntity blockEntity2 = (BasicLootBlockEntity)blockEntity;
            blockEntity2.updateOpenerCount();
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TYPE});
        builder.m_61104_(new Property[]{OPEN});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CabinetBlockEntity(pos, state);
    }

    public static enum Type implements StringRepresentable
    {
        SINGLE("single"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle");

        private final String id;

        private Type(String id) {
            this.id = id;
        }

        public String m_7912_() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }
    }
}

