/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import com.nosiphus.furniture.blockentity.ToasterBlockEntity;
import com.nosiphus.furniture.core.ModBlockEntities;
import com.nosiphus.furniture.item.crafting.ToastingRecipe;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ToasterBlock
extends FurnitureHorizontalBlock
implements EntityBlock {
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public ToasterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] LEVER = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)7.0, (double)4.0, (double)2.5, (double)9.0, (double)4.8, (double)3.5), (Direction)Direction.EAST));
        VoxelShape[] NORTH_SIDE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)6.5, (double)0.0, (double)3.5, (double)9.5, (double)6.4, (double)4.5), (Direction)Direction.EAST));
        VoxelShape[] WEST_SIDE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)5.5, (double)0.0, (double)3.5, (double)6.5, (double)6.4, (double)12.5), (Direction)Direction.EAST));
        VoxelShape[] CENTER = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)7.5, (double)0.0, (double)4.5, (double)8.5, (double)6.4, (double)11.5), (Direction)Direction.EAST));
        VoxelShape[] EAST_SIDE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)9.5, (double)0.0, (double)3.5, (double)10.5, (double)6.4, (double)12.5), (Direction)Direction.EAST));
        VoxelShape[] SOUTH_SIDE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)6.5, (double)0.0, (double)11.5, (double)9.5, (double)6.4, (double)12.5), (Direction)Direction.EAST));
        VoxelShape[] BASE = VoxelShapeHelper.getRotatedShapes((VoxelShape)VoxelShapeHelper.rotate((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)1.0, (double)13.0), (Direction)Direction.EAST));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(LEVER[direction.m_122416_()]);
            shapes.add(NORTH_SIDE[direction.m_122416_()]);
            shapes.add(WEST_SIDE[direction.m_122416_()]);
            shapes.add(CENTER[direction.m_122416_()]);
            shapes.add(EAST_SIDE[direction.m_122416_()]);
            shapes.add(SOUTH_SIDE[direction.m_122416_()]);
            shapes.add(BASE[direction.m_122416_()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public int getDirection(BlockState state) {
        if (state.m_61143_((Property)DIRECTION) == Direction.NORTH) {
            return 0;
        }
        if (state.m_61143_((Property)DIRECTION) == Direction.EAST) {
            return 1;
        }
        if (state.m_61143_((Property)DIRECTION) == Direction.SOUTH) {
            return 2;
        }
        if (state.m_61143_((Property)DIRECTION) == Direction.WEST) {
            return 3;
        }
        return 0;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ToasterBlockEntity) {
                ToasterBlockEntity blockEntity2 = (ToasterBlockEntity)blockEntity;
                Containers.m_19010_((Level)level, (BlockPos)pos, blockEntity2.getToaster());
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && result.m_82434_() == Direction.UP && (blockEntity = level.m_7702_(pos)) instanceof ToasterBlockEntity) {
            ToasterBlockEntity blockEntity2 = (ToasterBlockEntity)blockEntity;
            ItemStack stack = player.m_21120_(hand);
            if (!stack.m_41619_()) {
                Optional<ToastingRecipe> optional = blockEntity2.findMatchingRecipe(stack);
                if (optional.isPresent()) {
                    ToastingRecipe recipe = optional.get();
                    if (blockEntity2.addItem(stack, this.getPosition(result, pos, state), recipe.m_43753_(), recipe.m_43750_()) && !player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                }
            } else {
                blockEntity2.removeItem(this.getPosition(result, pos, state));
            }
        }
        return InteractionResult.SUCCESS;
    }

    private int getPosition(BlockHitResult result, BlockPos pos, BlockState state) {
        Vec3 hitVec = result.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        int position = 0;
        int direction = this.getDirection(state);
        switch (direction) {
            case 0: {
                if (!(hitVec.m_7094_() > 0.5)) break;
                position = 1;
                break;
            }
            case 1: {
                if (!(hitVec.m_7096_() > 0.5)) break;
                position = 1;
                break;
            }
            case 2: {
                if (!(hitVec.m_7094_() < 0.5)) break;
                position = 1;
                break;
            }
            case 3: {
                if (!(hitVec.m_7096_() < 0.5)) break;
                position = 1;
            }
        }
        return position;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ToasterBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return ToasterBlock.createMailBoxTicker(level, type, (BlockEntityType<? extends ToasterBlockEntity>)((BlockEntityType)ModBlockEntities.TOASTER.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createMailBoxTicker(Level level, BlockEntityType<T> blockEntityType, BlockEntityType<? extends ToasterBlockEntity> toasterBlockEntity) {
        return ToasterBlock.createTickerHelper(blockEntityType, toasterBlockEntity, ToasterBlockEntity::tick);
    }
}

