/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.blockentity;

import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.util.BlockEntityUtil;
import com.mrcrayfish.furniture.util.ItemStackHelper;
import com.nosiphus.furniture.core.ModBlockEntities;
import com.nosiphus.furniture.core.ModRecipeTypes;
import com.nosiphus.furniture.item.crafting.ToastingRecipe;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ToasterBlockEntity
extends BlockEntity
implements WorldlyContainer {
    public static final int[] ALL_SLOTS = new int[]{0, 1};
    public static final int[] TOAST_SLOTS = new int[]{0, 1};
    private final NonNullList<ItemStack> toaster = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private final int[] cookingTimes = new int[2];
    private final int[] cookingTotalTimes = new int[2];
    private final float[] experience = new float[2];

    protected ToasterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ToasterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TOASTER.get(), pos, state);
    }

    public int getDirection(BlockState state) {
        if (state.m_61143_((Property)FurnitureHorizontalBlock.DIRECTION) == Direction.NORTH) {
            return 0;
        }
        if (state.m_61143_((Property)FurnitureHorizontalBlock.DIRECTION) == Direction.EAST) {
            return 1;
        }
        if (state.m_61143_((Property)FurnitureHorizontalBlock.DIRECTION) == Direction.SOUTH) {
            return 2;
        }
        if (state.m_61143_((Property)FurnitureHorizontalBlock.DIRECTION) == Direction.WEST) {
            return 3;
        }
        return 0;
    }

    public NonNullList<ItemStack> getToaster() {
        return this.toaster;
    }

    public boolean addItem(ItemStack stack, int position, int cookTime, float experience) {
        if (((ItemStack)this.toaster.get(position)).m_41619_()) {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            this.toaster.set(position, (Object)copy);
            this.resetPosition(position, cookTime, experience);
            return true;
        }
        return false;
    }

    private void resetPosition(int position, int cookTime, float experience) {
        this.cookingTimes[position] = 0;
        this.cookingTotalTimes[position] = cookTime / 2;
        this.experience[position] = 0.0f;
        CompoundTag compound = new CompoundTag();
        this.writeItems(compound);
        this.writeCookingTimes(compound);
        this.writeCookingTotalTimes(compound);
        BlockEntityUtil.sendUpdatePacket((BlockEntity)this, (CompoundTag)compound);
    }

    public void removeItem(int position) {
        if (!((ItemStack)this.toaster.get(position)).m_41619_()) {
            double posX = (double)this.f_58858_.m_123341_() + 0.5;
            double posY = this.f_58858_.m_123342_();
            double posZ = (double)this.f_58858_.m_123343_() + 0.5;
            ItemEntity entity = new ItemEntity(this.f_58857_, posX, posY, posZ, ((ItemStack)this.toaster.get(position)).m_41777_());
            this.f_58857_.m_7967_((Entity)entity);
            this.toaster.set(position, (Object)ItemStack.f_41583_);
            if (this.cookingTimes[position] == this.cookingTotalTimes[position]) {
                int splitAmount;
                for (int amount = (int)this.experience[position]; amount > 0; amount -= splitAmount) {
                    splitAmount = ExperienceOrb.m_20782_((int)amount);
                    this.f_58857_.m_7967_((Entity)new ExperienceOrb(this.f_58857_, posX, posY, posZ, splitAmount));
                }
            }
            CompoundTag compound = new CompoundTag();
            this.writeItems(compound);
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, (CompoundTag)compound);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ToasterBlockEntity blockEntity) {
        boolean canToast = blockEntity.canToast();
        if (canToast) {
            blockEntity.toastItems();
        }
    }

    private boolean canToast() {
        for (int i = 0; i < this.toaster.size(); ++i) {
            if (((ItemStack)this.toaster.get(i)).m_41619_() || this.cookingTimes[i] == this.cookingTotalTimes[i]) continue;
            return true;
        }
        return false;
    }

    private void toastItems() {
        boolean itemsChanged = false;
        for (int i = 0; i < this.toaster.size(); ++i) {
            if (((ItemStack)this.toaster.get(i)).m_41619_() || this.cookingTimes[i] >= this.cookingTotalTimes[i]) continue;
            int n = i;
            this.cookingTimes[n] = this.cookingTimes[n] + 1;
            if (this.cookingTimes[i] != this.cookingTotalTimes[i]) continue;
            Optional optional = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.TOASTING.get(), (Container)new SimpleContainer(new ItemStack[]{(ItemStack)this.toaster.get(i)}), this.f_58857_);
            if (optional.isPresent()) {
                this.toaster.set(i, (Object)((ToastingRecipe)((Object)optional.get())).m_8043_(this.f_58857_.m_9598_()).m_41777_());
            }
            itemsChanged = true;
        }
        if (itemsChanged) {
            CompoundTag compound = new CompoundTag();
            this.writeItems(compound);
            this.writeCookingTimes(compound);
            BlockEntityUtil.sendUpdatePacket((BlockEntity)this, (CompoundTag)compound);
        }
    }

    private boolean isToasting() {
        for (int i = 0; i < this.toaster.size(); ++i) {
            if (((ItemStack)this.toaster.get(i)).m_41619_() || this.cookingTimes[i] == this.cookingTotalTimes[i]) continue;
            return true;
        }
        return false;
    }

    public Optional<ToastingRecipe> findMatchingRecipe(ItemStack input) {
        return this.toaster.stream().noneMatch(ItemStack::m_41619_) ? Optional.empty() : this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.TOASTING.get(), (Container)new SimpleContainer(new ItemStack[]{input}), this.f_58857_);
    }

    public int m_6643_() {
        return this.toaster.size();
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.toaster) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.toaster.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack result = ContainerHelper.m_18969_(this.toaster, (int)index, (int)count);
        if (((ItemStack)this.toaster.get(index)).m_41619_() && this.cookingTimes[index] == this.cookingTotalTimes[index]) {
            int splitAmount;
            double posX = (double)this.f_58858_.m_123341_() + 0.5;
            double posY = this.f_58858_.m_123342_();
            double posZ = (double)this.f_58858_.m_123343_() + 0.5;
            for (int amount = (int)this.experience[index]; amount > 0; amount -= splitAmount) {
                splitAmount = ExperienceOrb.m_20782_((int)amount);
                this.f_58857_.m_7967_((Entity)new ExperienceOrb(this.f_58857_, posX, posY, posZ, splitAmount));
            }
        }
        CompoundTag compound = new CompoundTag();
        this.writeItems(compound);
        BlockEntityUtil.sendUpdatePacket((BlockEntity)this, (CompoundTag)compound);
        return result;
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.toaster, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        NonNullList<ItemStack> inventory = this.toaster;
        Optional optional = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.TOASTING.get(), (Container)new SimpleContainer(new ItemStack[]{stack}), this.f_58857_);
        if (optional.isPresent()) {
            ToastingRecipe recipe = (ToastingRecipe)((Object)optional.get());
            this.resetPosition(index, recipe.m_43753_(), recipe.m_43750_());
        }
        inventory.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        CompoundTag compound = new CompoundTag();
        this.writeItems(compound);
        BlockEntityUtil.sendUpdatePacket((BlockEntity)this, (CompoundTag)compound);
    }

    public int m_6893_() {
        return 1;
    }

    public void m_6211_() {
        this.toaster.clear();
    }

    public void m_142466_(CompoundTag compound) {
        int[] cookingTimes;
        super.m_142466_(compound);
        if (compound.m_128425_("Toaster", 9)) {
            this.toaster.clear();
            ItemStackHelper.loadAllItems((String)"Toaster", (CompoundTag)compound, this.toaster);
        }
        if (compound.m_128425_("CookingTimes", 11)) {
            cookingTimes = compound.m_128465_("CookingTimes");
            System.arraycopy(cookingTimes, 0, this.cookingTimes, 0, Math.min(this.cookingTotalTimes.length, cookingTimes.length));
        }
        if (compound.m_128425_("CookingTotalTimes", 11)) {
            cookingTimes = compound.m_128465_("CookingTotalTimes");
            System.arraycopy(cookingTimes, 0, this.cookingTotalTimes, 0, Math.min(this.cookingTotalTimes.length, cookingTimes.length));
        }
        if (compound.m_128425_("Experience", 11)) {
            int[] experience = compound.m_128465_("Experience");
            for (int i = 0; i < Math.min(this.experience.length, experience.length); ++i) {
                this.experience[i] = Float.intBitsToFloat(experience[i]);
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeItems(tag);
        this.writeCookingTimes(tag);
        this.writeCookingTotalTimes(tag);
        this.writeExperience(tag);
    }

    private CompoundTag writeItems(CompoundTag compound) {
        ItemStackHelper.saveAllItems((String)"Toaster", (CompoundTag)compound, this.toaster, (boolean)true);
        return compound;
    }

    private CompoundTag writeCookingTimes(CompoundTag compound) {
        compound.m_128385_("CookingTimes", this.cookingTimes);
        return compound;
    }

    private CompoundTag writeCookingTotalTimes(CompoundTag compound) {
        compound.m_128385_("CookingTotalTimes", this.cookingTotalTimes);
        return compound;
    }

    private CompoundTag writeExperience(CompoundTag compound) {
        int[] experience = new int[this.experience.length];
        for (int i = 0; i < this.experience.length; ++i) {
            experience[i] = Float.floatToIntBits(experience[i]);
        }
        compound.m_128385_("Experience", experience);
        return compound;
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compound = pkt.m_131708_();
        this.m_142466_(compound);
    }

    public boolean m_6542_(Player player) {
        return this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public int[] m_7071_(Direction side) {
        return side == Direction.DOWN ? TOAST_SLOTS : ALL_SLOTS;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        if (!this.m_8020_(index).m_41619_()) {
            return false;
        }
        if (index >= 0) {
            return this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.TOASTING.get(), (Container)new SimpleContainer(new ItemStack[]{stack}), this.f_58857_).isPresent();
        }
        return false;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        if (direction == Direction.DOWN && index >= 0 && this.cookingTimes[index] == this.cookingTotalTimes[index]) {
            Optional optional = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.TOASTING.get(), (Container)new SimpleContainer(new ItemStack[]{stack}), this.f_58857_);
            return !optional.isPresent();
        }
        return false;
    }
}

