/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.blockentity;

import com.nosiphus.furniture.core.ModBlockEntities;
import com.nosiphus.furniture.core.ModFluids;
import com.nosiphus.furniture.inventory.container.WashingMachineMenu;
import com.nosiphus.furniture.network.PacketHandler;
import com.nosiphus.furniture.network.message.S2CMessageWashingMachineSync;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WashingMachineBlockEntity
extends BlockEntity
implements MenuProvider {
    private boolean washing = false;
    private final ItemStackHandler itemHandler = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            WashingMachineBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.m_41720_() instanceof ArmorItem;
                case 1 -> stack.m_41720_() instanceof ArmorItem;
                case 2 -> stack.m_41720_() instanceof ArmorItem;
                case 3 -> stack.m_41720_() instanceof ArmorItem;
                case 4 -> stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private final FluidTank FLUID_TANK = new FluidTank(64000){

        protected void onContentsChanged() {
            WashingMachineBlockEntity.this.m_6596_();
            if (!WashingMachineBlockEntity.this.f_58857_.m_5776_()) {
                PacketHandler.getPlayChannel().send(PacketDistributor.TRACKING_CHUNK.with(() -> WashingMachineBlockEntity.this.f_58857_.m_46745_(WashingMachineBlockEntity.this.f_58858_)), (Object)new S2CMessageWashingMachineSync(this.fluid, WashingMachineBlockEntity.this.f_58858_, WashingMachineBlockEntity.this.washing));
            }
        }

        public boolean isFluidValid(FluidStack stack) {
            if (WashingMachineBlockEntity.this.FLUID_TANK.isEmpty()) {
                return stack.getFluid() == ModFluids.SOAPY_WATER.get() || stack.getFluid() == ModFluids.SUPER_SOAPY_WATER.get();
            }
            if (WashingMachineBlockEntity.this.FLUID_TANK.getFluid().getFluid() == ModFluids.SOAPY_WATER.get()) {
                return stack.getFluid() == ModFluids.SOAPY_WATER.get();
            }
            if (WashingMachineBlockEntity.this.FLUID_TANK.getFluid().getFluid() == ModFluids.SUPER_SOAPY_WATER.get()) {
                return stack.getFluid() == ModFluids.SUPER_SOAPY_WATER.get();
            }
            return false;
        }
    };
    private LazyOptional<IFluidHandler> lazyFluidHandler = LazyOptional.empty();
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();

    public void setFluid(FluidStack stack) {
        this.FLUID_TANK.setFluid(stack);
    }

    public FluidStack getFluidStack() {
        return this.FLUID_TANK.getFluid();
    }

    public void setWashing(boolean washing) {
        this.washing = washing;
    }

    public boolean getWashing() {
        return this.washing;
    }

    public WashingMachineBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.WASHING_MACHINE.get(), pos, state);
    }

    public int getContainerSize() {
        return 6;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.nfm.washing_machine");
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        PacketHandler.getPlayChannel().send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new S2CMessageWashingMachineSync(this.FLUID_TANK.getFluid(), this.f_58858_, this.washing));
        return new WashingMachineMenu(id, inventory, this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidHandler.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyFluidHandler = LazyOptional.of(() -> this.FLUID_TANK);
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyFluidHandler.invalidate();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag tag) {
        tag = this.FLUID_TANK.writeToNBT(tag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.FLUID_TANK.readFromNBT(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WashingMachineBlockEntity blockEntity) {
        if (level.m_5776_()) {
            return;
        }
        if (WashingMachineBlockEntity.hasFluidItemInSourceSlot(blockEntity)) {
            WashingMachineBlockEntity.transferItemFluidToFluidTank(blockEntity);
        }
        if (WashingMachineBlockEntity.hasRepairableItem(blockEntity, 0)) {
            WashingMachineBlockEntity.repairItem(blockEntity, 0);
            WashingMachineBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
        if (WashingMachineBlockEntity.hasRepairableItem(blockEntity, 1)) {
            WashingMachineBlockEntity.repairItem(blockEntity, 1);
            WashingMachineBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
        if (WashingMachineBlockEntity.hasRepairableItem(blockEntity, 2)) {
            WashingMachineBlockEntity.repairItem(blockEntity, 2);
            WashingMachineBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
        if (WashingMachineBlockEntity.hasRepairableItem(blockEntity, 3)) {
            WashingMachineBlockEntity.repairItem(blockEntity, 3);
            WashingMachineBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private static void repairItem(WashingMachineBlockEntity blockEntity, int slot) {
        ItemStack itemInSlot = blockEntity.itemHandler.getStackInSlot(slot);
        itemInSlot.m_41721_(itemInSlot.m_41773_() - 1);
        if (itemInSlot.m_41773_() == 0) {
            blockEntity.washing = false;
        }
        if (blockEntity.getFluidStack().getFluid() == ModFluids.SOAPY_WATER.get()) {
            blockEntity.FLUID_TANK.drain(20, IFluidHandler.FluidAction.EXECUTE);
            if (blockEntity.getFluidStack().getAmount() < 20) {
                blockEntity.washing = false;
            }
        }
        if (blockEntity.getFluidStack().getFluid() == ModFluids.SUPER_SOAPY_WATER.get()) {
            blockEntity.FLUID_TANK.drain(10, IFluidHandler.FluidAction.EXECUTE);
            if (blockEntity.getFluidStack().getAmount() < 10) {
                blockEntity.washing = false;
            }
        }
        if (blockEntity.getFluidStack().isEmpty()) {
            blockEntity.washing = false;
        }
    }

    private static boolean hasRepairableItem(WashingMachineBlockEntity blockEntity, int slot) {
        boolean isDamaged;
        if (blockEntity.itemHandler.getStackInSlot(slot).m_41773_() > 0) {
            isDamaged = true;
            blockEntity.washing = true;
        } else {
            isDamaged = false;
            blockEntity.washing = false;
        }
        return isDamaged && WashingMachineBlockEntity.hasCorrectFluidAmountInTank(blockEntity);
    }

    private static boolean hasCorrectFluidAmountInTank(WashingMachineBlockEntity blockEntity) {
        return blockEntity.FLUID_TANK.getFluidAmount() > 0;
    }

    private static void transferItemFluidToFluidTank(WashingMachineBlockEntity blockEntity) {
        blockEntity.itemHandler.getStackInSlot(4).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> {
            int drainAmount = Math.min(blockEntity.FLUID_TANK.getSpace(), 1000);
            FluidStack stack = handler.drain(drainAmount, IFluidHandler.FluidAction.SIMULATE);
            if (blockEntity.FLUID_TANK.isFluidValid(stack)) {
                stack = handler.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                WashingMachineBlockEntity.fillTankWithFluid(blockEntity, stack, handler.getContainer());
            }
        });
    }

    private static void fillTankWithFluid(WashingMachineBlockEntity blockEntity, FluidStack stack, ItemStack container) {
        blockEntity.FLUID_TANK.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        blockEntity.itemHandler.extractItem(4, 1, false);
        blockEntity.itemHandler.insertItem(4, container, false);
    }

    private static boolean hasFluidItemInSourceSlot(WashingMachineBlockEntity blockEntity) {
        return blockEntity.itemHandler.getStackInSlot(4).m_41613_() > 0;
    }

    public boolean stillValid(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }
}

