/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.inventory.container;

import com.mojang.datafixers.util.Pair;
import com.nosiphus.furniture.blockentity.WashingMachineBlockEntity;
import com.nosiphus.furniture.core.ModFluids;
import com.nosiphus.furniture.core.ModMenuTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class WashingMachineMenu
extends AbstractContainerMenu {
    public static final ResourceLocation BLOCK_ATLAS = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_HELMET = new ResourceLocation("item/empty_armor_slot_helmet");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_CHESTPLATE = new ResourceLocation("item/empty_armor_slot_chestplate");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_LEGGINGS = new ResourceLocation("item/empty_armor_slot_leggings");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_BOOTS = new ResourceLocation("item/empty_armor_slot_boots");
    public static final ResourceLocation EMPTY_TOOL_SLOT_BUCKET = new ResourceLocation("nfm", "item/empty_tool_slot_bucket");
    protected final WashingMachineBlockEntity blockEntity;
    private final Level level;
    private FluidStack fluidStack;
    private boolean washing;

    public WashingMachineMenu(int id, Inventory inventory, FriendlyByteBuf extraData) {
        this(id, inventory, inventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_()));
    }

    public WashingMachineMenu(int id, Inventory inventory, BlockEntity entity) {
        super((MenuType)ModMenuTypes.WASHING_MACHINE.get(), id);
        int i;
        WashingMachineMenu.m_38869_((Container)inventory, (int)6);
        this.blockEntity = (WashingMachineBlockEntity)entity;
        this.level = inventory.f_35978_.m_9236_();
        this.fluidStack = this.blockEntity.getFluidStack();
        this.washing = this.blockEntity.getWashing();
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)iItemHandler, 0, 80, 44){

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)BLOCK_ATLAS, (Object)EMPTY_ARMOR_SLOT_HELMET);
                }
            });
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)iItemHandler, 1, 64, 60){

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)BLOCK_ATLAS, (Object)EMPTY_ARMOR_SLOT_CHESTPLATE);
                }
            });
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)iItemHandler, 2, 96, 60){

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)BLOCK_ATLAS, (Object)EMPTY_ARMOR_SLOT_LEGGINGS);
                }
            });
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)iItemHandler, 3, 80, 76){

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)BLOCK_ATLAS, (Object)EMPTY_ARMOR_SLOT_BOOTS);
                }
            });
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 4, 125, 7));
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)iItemHandler, 4, 125, 7){

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)BLOCK_ATLAS, (Object)EMPTY_TOOL_SLOT_BUCKET);
                }
            });
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, j * 18 + 8, i * 18 + 146));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, i * 18 + 8, 204));
        }
    }

    public void setFluid(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public WashingMachineBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public void setWashing(boolean washing) {
        this.washing = washing;
    }

    public boolean getWashing() {
        return this.washing;
    }

    public int getFluidType() {
        int fluidType = 0;
        if (this.getFluidStack().getFluid() == ModFluids.SOAPY_WATER.get()) {
            fluidType = 192;
        } else if (this.getFluidStack().getFluid() == ModFluids.SUPER_SOAPY_WATER.get()) {
            fluidType = 212;
        }
        return fluidType;
    }

    public int getFluidRenderAmount() {
        int actualAmount = this.getFluidStack().getAmount();
        int actualMaxAmount = 64000;
        int tankSize = 73;
        return actualAmount * tankSize / actualMaxAmount;
    }

    public ItemStack m_7648_(Player playerEntity, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < this.blockEntity.getContainerSize() ? !this.m_38903_(slotStack, this.blockEntity.getContainerSize(), this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.blockEntity.getContainerSize(), false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public boolean m_6875_(Player player) {
        return this.blockEntity.stillValid(player);
    }
}

