/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nosiphus.furniture.core.ModBlocks;
import com.nosiphus.furniture.core.ModRecipeSerializers;
import com.nosiphus.furniture.core.ModRecipeTypes;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;

public class ChoppingRecipe
implements Recipe<Container> {
    public final Ingredient base;
    public final ItemStack result;
    private final ResourceLocation id;

    public ChoppingRecipe(ResourceLocation id, Ingredient base, ItemStack result) {
        this.id = id;
        this.base = base;
        this.result = result;
    }

    public boolean m_5818_(Container container, Level level) {
        return this.base.test(container.m_8020_(0));
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        ItemStack itemStack = this.result.m_41777_();
        CompoundTag compoundTag = container.m_8020_(0).m_41783_();
        if (compoundTag != null) {
            itemStack.m_41751_(compoundTag.m_6426_());
        }
        return itemStack;
    }

    public boolean m_8004_(int int1, int int2) {
        return int1 * int2 >= 2;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.CHOPPING_BOARD_OAK.get());
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.CHOPPING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.CHOPPING.get();
    }

    public boolean m_142505_() {
        return Stream.of(this.base).anyMatch(ingredient -> ForgeHooks.hasNoElements((Ingredient)ingredient));
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<ChoppingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("nfm", "chopping");

        public ChoppingRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"base"));
            ItemStack itemStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            return new ChoppingRecipe(resourceLocation, ingredient, itemStack);
        }

        public ChoppingRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf);
            ItemStack itemStack = friendlyByteBuf.m_130267_();
            return new ChoppingRecipe(resourceLocation, ingredient, itemStack);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, ChoppingRecipe choppingRecipe) {
            choppingRecipe.base.m_43923_(friendlyByteBuf);
            friendlyByteBuf.m_130055_(choppingRecipe.result);
        }
    }
}

