/*
 * Decompiled with CFR 0.152.
 */
package com.nosiphus.furniture.network;

import com.mrcrayfish.furniture.network.message.IMessage;
import com.nosiphus.furniture.network.message.C2SMessageEmptyBin;
import com.nosiphus.furniture.network.message.S2CMessageDishwasherSync;
import com.nosiphus.furniture.network.message.S2CMessageWashingMachineSync;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    public static final String PROTOCOL_VERSION = "1";
    private static SimpleChannel instance;
    private static int nextId;

    public static void init() {
        instance = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("nfm", "network")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).simpleChannel();
        PacketHandler.register(C2SMessageEmptyBin.class, new C2SMessageEmptyBin(), NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.register(S2CMessageDishwasherSync.class, new S2CMessageDishwasherSync(), NetworkDirection.PLAY_TO_CLIENT);
        PacketHandler.register(S2CMessageWashingMachineSync.class, new S2CMessageWashingMachineSync(), NetworkDirection.PLAY_TO_CLIENT);
    }

    private static <T> void register(Class<T> clazz, IMessage<T> message, @Nullable NetworkDirection direction) {
        instance.registerMessage(nextId++, clazz, (arg_0, arg_1) -> message.encode(arg_0, arg_1), arg_0 -> message.decode(arg_0), (arg_0, arg_1) -> message.handle(arg_0, arg_1), Optional.ofNullable(direction));
    }

    public static SimpleChannel getPlayChannel() {
        return instance;
    }

    static {
        nextId = 0;
    }
}

