/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui;

import cofh.core.client.gui.ContainerScreenCoFH;
import cofh.core.client.gui.element.ElementButton;
import cofh.core.client.gui.element.ElementTexture;
import cofh.core.client.gui.element.SimpleTooltip;
import cofh.core.common.inventory.ItemFilterMenu;
import cofh.core.common.network.packet.server.FilterableGuiTogglePacket;
import cofh.core.util.filter.IFilterable;
import cofh.core.util.filter.IFilterableItem;
import cofh.core.util.helpers.FilterHelper;
import cofh.core.util.helpers.GuiHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.util.helpers.SoundHelper;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;

public class ItemFilterScreen
extends ContainerScreenCoFH<ItemFilterMenu> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("cofh_core:textures/gui/generic.png");
    public static final ResourceLocation SLOT_OVERLAY = new ResourceLocation("cofh_core:textures/gui/elements/locked_overlay_slot.png");
    public static final ResourceLocation TEX_DENY_LIST = new ResourceLocation("cofh_core:textures/gui/filters/filter_deny_list.png");
    public static final ResourceLocation TEX_ALLOW_LIST = new ResourceLocation("cofh_core:textures/gui/filters/filter_allow_list.png");
    public static final ResourceLocation TEX_IGNORE_NBT = new ResourceLocation("cofh_core:textures/gui/filters/filter_ignore_nbt.png");
    public static final ResourceLocation TEX_USE_NBT = new ResourceLocation("cofh_core:textures/gui/filters/filter_use_nbt.png");

    public ItemFilterScreen(ItemFilterMenu container, Inventory inv, Component titleIn) {
        super(container, inv, titleIn);
        this.texture = TEXTURE;
        this.info = GuiHelper.generatePanelInfo("info.cofh_core.item_filter");
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        for (int i = 0; i < ((ItemFilterMenu)this.f_97732_).getFilterSize(); ++i) {
            Slot slot = (Slot)((ItemFilterMenu)this.f_97732_).f_38839_.get(i);
            this.addElement(GuiHelper.createSlot(this, slot.f_40220_, slot.f_40221_));
        }
        this.addButtons();
        switch (((ItemFilterMenu)this.f_97732_).type) {
            case ITEM: {
                if (!((ItemFilterMenu)this.f_97732_).getFilterableItem().hasGui(((ItemFilterMenu)this.f_97732_).getFilterStack())) break;
                this.addElement(new ElementTexture(this, 4, -21).setUV(24, 0).setSize(24, 21).setTexture(GuiHelper.TAB_TOP, 48, 32).setVisible(() -> FilterHelper.hasFilter(((ItemFilterMenu)this.f_97732_).getFilterStack())));
                this.addElement(new ElementTexture(this, 8, -17){

                    @Override
                    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                        FilterableGuiTogglePacket.openGui(((ItemFilterMenu)ItemFilterScreen.this.f_97732_).getFilterStack());
                        return true;
                    }
                }.setSize(16, 16).setTexture(GuiHelper.NAV_BACK, 16, 16).setTooltipFactory((element, mouseX, mouseY) -> {
                    List<Object> list;
                    IFilterableItem patt3294$temp = ((ItemFilterMenu)this.f_97732_).getFilterableItem();
                    if (patt3294$temp instanceof MenuProvider) {
                        MenuProvider menuProvider = (MenuProvider)patt3294$temp;
                        list = Collections.singletonList(menuProvider.m_5446_());
                    } else {
                        list = Collections.emptyList();
                    }
                    return list;
                }).setVisible(() -> FilterHelper.hasFilter(((ItemFilterMenu)this.f_97732_).getFilterStack())));
                break;
            }
            case TILE: 
            case ENTITY: {
                if (!((ItemFilterMenu)this.f_97732_).getFilterable().hasGui()) break;
                this.addElement(new ElementTexture(this, 4, -21).setUV(24, 0).setSize(24, 21).setTexture(GuiHelper.TAB_TOP, 48, 32).setVisible(() -> FilterHelper.hasFilter(((ItemFilterMenu)this.f_97732_).getFilterable())));
                this.addElement(new ElementTexture(this, 8, -17){

                    @Override
                    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                        FilterableGuiTogglePacket.openGui(((ItemFilterMenu)ItemFilterScreen.this.f_97732_).getFilterable());
                        return true;
                    }
                }.setSize(16, 16).setTexture(GuiHelper.NAV_BACK, 16, 16).setTooltipFactory((element, mouseX, mouseY) -> {
                    List<Object> list;
                    IFilterable patt4545$temp = ((ItemFilterMenu)this.f_97732_).getFilterable();
                    if (patt4545$temp instanceof MenuProvider) {
                        MenuProvider menuProvider = (MenuProvider)patt4545$temp;
                        list = Collections.singletonList(menuProvider.m_5446_());
                    } else {
                        list = Collections.emptyList();
                    }
                    return list;
                }).setVisible(() -> FilterHelper.hasFilter(((ItemFilterMenu)this.f_97732_).getFilterable())));
            }
        }
    }

    @Override
    protected void m_280003_(GuiGraphics pGuiGraphics, int mouseX, int mouseY) {
        super.m_280003_(pGuiGraphics, mouseX, mouseY);
        if (((ItemFilterMenu)this.f_97732_).lockedSlot != null) {
            GlStateManager._enableBlend();
            RenderHelper.setPosTexShader();
            RenderHelper.setShaderTexture0(SLOT_OVERLAY);
            this.drawTexturedModalRect(pGuiGraphics.m_280168_(), ((ItemFilterMenu)this.f_97732_).lockedSlot.f_40220_, ((ItemFilterMenu)this.f_97732_).lockedSlot.f_40221_, 0, 0, 16, 16, 16.0f, 16.0f);
            GlStateManager._disableBlend();
        }
    }

    protected void addButtons() {
        this.addElement(new ElementButton(this, 132, 22){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((ItemFilterMenu)ItemFilterScreen.this.f_97732_).setAllowList(true);
                SoundHelper.playClickSound(0.7f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_DENY_LIST, 40, 20).setTooltipFactory(new SimpleTooltip((Component)Component.m_237115_((String)"info.cofh.filter.allowlist.0"))).setVisible(() -> !((ItemFilterMenu)this.f_97732_).getAllowList()));
        this.addElement(new ElementButton(this, 132, 22){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((ItemFilterMenu)ItemFilterScreen.this.f_97732_).setAllowList(false);
                SoundHelper.playClickSound(0.4f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_ALLOW_LIST, 40, 20).setTooltipFactory(new SimpleTooltip((Component)Component.m_237115_((String)"info.cofh.filter.allowlist.1"))).setVisible(() -> ((ItemFilterMenu)this.f_97732_).getAllowList()));
        this.addElement(new ElementButton(this, 132, 44){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((ItemFilterMenu)ItemFilterScreen.this.f_97732_).setCheckNBT(true);
                SoundHelper.playClickSound(0.7f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_IGNORE_NBT, 40, 20).setTooltipFactory(new SimpleTooltip((Component)Component.m_237115_((String)"info.cofh.filter.checkNBT.0"))).setVisible(() -> !((ItemFilterMenu)this.f_97732_).getCheckNBT()));
        this.addElement(new ElementButton(this, 132, 44){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                ((ItemFilterMenu)ItemFilterScreen.this.f_97732_).setCheckNBT(false);
                SoundHelper.playClickSound(0.4f);
                return true;
            }
        }.setSize(20, 20).setTexture(TEX_USE_NBT, 40, 20).setTooltipFactory(new SimpleTooltip((Component)Component.m_237115_((String)"info.cofh.filter.checkNBT.1"))).setVisible(() -> ((ItemFilterMenu)this.f_97732_).getCheckNBT()));
    }
}

