/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element.panel;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementButton;
import cofh.core.client.gui.element.SimpleTooltip;
import cofh.core.client.gui.element.panel.PanelBase;
import cofh.core.util.helpers.GuiHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.api.control.ISecurable;
import cofh.lib.util.helpers.SoundHelper;
import cofh.lib.util.helpers.StringHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class SecurityPanel
extends PanelBase {
    public static final String TEX_ACCESS_PUBLIC = "cofh_core:textures/gui/elements/button_access_public.png";
    public static final String TEX_ACCESS_PRIVATE = "cofh_core:textures/gui/elements/button_access_private.png";
    public static final String TEX_ACCESS_FRIENDS = "cofh_core:textures/gui/elements/button_access_friends.png";
    public static final String TEX_ACCESS_TEAM = "cofh_core:textures/gui/elements/button_access_team.png";
    public static int defaultSide = 0;
    public static int defaultHeaderColor = 14797103;
    public static int defaultSubHeaderColor = 11186104;
    public static int defaultTextColor = 0xF0F0F0;
    public static int defaultBackgroundColor = 0x50B050;
    private final ISecurable mySecurable;
    private final UUID myPlayer;

    public SecurityPanel(IGuiAccess gui, ISecurable securable, UUID playerID) {
        this(gui, defaultSide, securable, playerID);
    }

    protected SecurityPanel(IGuiAccess gui, int sideIn, ISecurable securable, UUID playerID) {
        super(gui, sideIn);
        this.headerColor = defaultHeaderColor;
        this.subheaderColor = defaultSubHeaderColor;
        this.textColor = defaultTextColor;
        this.backgroundColor = defaultBackgroundColor;
        this.maxHeight = 92;
        this.maxWidth = 112;
        this.mySecurable = securable;
        this.myPlayer = playerID;
        this.setVisible(this.mySecurable::hasSecurity);
        this.addElement(new ElementButton(gui, 37, 21){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                SecurityPanel.this.mySecurable.setAccess(ISecurable.AccessMode.PUBLIC);
                SoundHelper.playClickSound(0.5f);
                return true;
            }
        }.setSize(18, 18).setTexture(TEX_ACCESS_PUBLIC, 54, 18).setTooltipFactory(new SimpleTooltip((Component)Component.m_237115_((String)"info.cofh.access_public"))).setEnabled(() -> this.mySecurable.getAccess() != ISecurable.AccessMode.PUBLIC));
        this.addElement(new ElementButton(gui, 57, 21){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                SecurityPanel.this.mySecurable.setAccess(ISecurable.AccessMode.PRIVATE);
                SoundHelper.playClickSound(0.8f);
                return true;
            }
        }.setSize(18, 18).setTexture(TEX_ACCESS_PRIVATE, 54, 18).setTooltipFactory(new SimpleTooltip((Component)Component.m_237115_((String)"info.cofh.access_private"))).setEnabled(() -> this.mySecurable.getAccess() != ISecurable.AccessMode.PRIVATE));
        this.addElement(new ElementButton(gui, 37, 41){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                SecurityPanel.this.mySecurable.setAccess(ISecurable.AccessMode.FRIENDS);
                SoundHelper.playClickSound(0.6f);
                return true;
            }
        }.setSize(18, 18).setTexture(TEX_ACCESS_FRIENDS, 54, 18).setTooltipFactory(new SimpleTooltip((Component)Component.m_237115_((String)"info.cofh.access_friends"))).setEnabled(() -> this.mySecurable.getAccess() != ISecurable.AccessMode.FRIENDS));
        this.addElement(new ElementButton(gui, 57, 41){

            @Override
            public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
                SecurityPanel.this.mySecurable.setAccess(ISecurable.AccessMode.TEAM);
                SoundHelper.playClickSound(0.7f);
                return true;
            }
        }.setSize(18, 18).setTexture(TEX_ACCESS_TEAM, 54, 18).setTooltipFactory(new SimpleTooltip((Component)Component.m_237115_((String)"info.cofh.access_team"))).setEnabled(() -> this.mySecurable.getAccess() != ISecurable.AccessMode.TEAM));
        this.tooltip = (element, mouseX, mouseY) -> {
            ArrayList<MutableComponent> tooltipList = new ArrayList<MutableComponent>();
            if (!this.fullyOpen) {
                tooltipList.add(Component.m_237115_((String)"info.cofh.owner").m_7220_((Component)Component.m_237113_((String)(": " + this.mySecurable.getOwnerName()))));
                switch (this.mySecurable.getAccess()) {
                    case PUBLIC: {
                        tooltipList.add(Component.m_237115_((String)"info.cofh.access_public").m_130940_(ChatFormatting.YELLOW));
                        break;
                    }
                    case PRIVATE: {
                        tooltipList.add(Component.m_237115_((String)"info.cofh.access_private").m_130940_(ChatFormatting.YELLOW));
                        break;
                    }
                    case FRIENDS: {
                        tooltipList.add(Component.m_237115_((String)"info.cofh.access_friends").m_130940_(ChatFormatting.YELLOW));
                        break;
                    }
                    case TEAM: {
                        tooltipList.add(Component.m_237115_((String)"info.cofh.access_team").m_130940_(ChatFormatting.YELLOW));
                    }
                }
            }
            return tooltipList;
        };
    }

    @Override
    protected void drawBackground(GuiGraphics pGuiGraphics) {
        switch (this.mySecurable.getAccess()) {
            case PUBLIC: {
                this.backgroundColor = 0x40A040;
                break;
            }
            case PRIVATE: {
                this.backgroundColor = 0xA04040;
                break;
            }
            case FRIENDS: {
                this.backgroundColor = 0xA0A040;
                break;
            }
            case TEAM: {
                this.backgroundColor = 9482304;
            }
        }
        super.drawBackground(pGuiGraphics);
        if (!this.fullyOpen) {
            return;
        }
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        RenderHelper.setPosTexShader();
        RenderSystem.setShaderColor((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        this.gui.drawTexturedModalRect(pGuiGraphics, 34, 18, 16, 20, 44, 44);
        RenderHelper.resetShaderColor();
    }

    @Override
    protected void drawForeground(GuiGraphics pGuiGraphics) {
        switch (this.mySecurable.getAccess()) {
            case PUBLIC: {
                this.drawPanelIcon(pGuiGraphics, GuiHelper.ICON_ACCESS_PUBLIC);
                break;
            }
            case PRIVATE: {
                this.drawPanelIcon(pGuiGraphics, GuiHelper.ICON_ACCESS_PRIVATE);
                break;
            }
            case FRIENDS: {
                this.drawPanelIcon(pGuiGraphics, GuiHelper.ICON_ACCESS_FRIENDS);
                break;
            }
            case TEAM: {
                this.drawPanelIcon(pGuiGraphics, GuiHelper.ICON_ACCESS_TEAM);
            }
        }
        if (!this.fullyOpen) {
            return;
        }
        pGuiGraphics.m_280056_(this.fontRenderer(), StringHelper.localize("info.cofh.security"), this.sideOffset() + 18, 6, this.headerColor, true);
        pGuiGraphics.m_280056_(this.fontRenderer(), StringHelper.localize("info.cofh.access") + ":", this.sideOffset() + 6, 66, this.subheaderColor, true);
        switch (this.mySecurable.getAccess()) {
            case PUBLIC: {
                pGuiGraphics.m_280056_(this.fontRenderer(), StringHelper.localize("info.cofh.access_public"), this.sideOffset() + 14, 78, this.textColor, false);
                break;
            }
            case PRIVATE: {
                pGuiGraphics.m_280056_(this.fontRenderer(), StringHelper.localize("info.cofh.access_private"), this.sideOffset() + 14, 78, this.textColor, false);
                break;
            }
            case FRIENDS: {
                pGuiGraphics.m_280056_(this.fontRenderer(), StringHelper.localize("info.cofh.access_friends"), this.sideOffset() + 14, 78, this.textColor, false);
                break;
            }
            case TEAM: {
                pGuiGraphics.m_280056_(this.fontRenderer(), StringHelper.localize("info.cofh.access_team"), this.sideOffset() + 14, 78, this.textColor, false);
            }
        }
        RenderHelper.resetShaderColor();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.myPlayer.equals(this.mySecurable.getOwner().getId())) {
            return true;
        }
        if (!this.fullyOpen) {
            return false;
        }
        if (super.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        double x = mouseX - (double)this.posX();
        double y = mouseY - (double)this.posY();
        return !(x < 34.0 || x >= 78.0 || y < 18.0 || y >= 62.0);
    }

    @Override
    public void setFullyOpen() {
        if (!this.myPlayer.equals(this.mySecurable.getOwner().getId())) {
            return;
        }
        super.setFullyOpen();
    }
}

