/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle.impl;

import cofh.core.client.particle.PointToPointParticle;
import cofh.core.client.particle.options.BiColorParticleOptions;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.vfx.Color;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ShardParticle
extends PointToPointParticle {
    protected Vector3f disp;

    private ShardParticle(BiColorParticleOptions data, ClientLevel level, double sx, double sy, double sz, double ex, double ey, double ez) {
        super(data, level, sx, sy, sz, ex, ey, ez);
        this.f_172258_ = 1.0f;
        this.disp = new Vector3f((float)(ex - sx), (float)(ey - sy), (float)(ez - sz));
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, VertexConsumer consumer, int packedLight, float time, float pTicks) {
        float progress = 1.0f - MathHelper.cos(time / this.duration * (float)Math.PI * 0.5f);
        float dx = this.disp.x() * progress;
        float dy = this.disp.y() * progress;
        float dz = this.disp.z() * progress;
        stack.m_252880_(dx, dy, dz);
        float dist = MathHelper.dist(dx, dy, dz);
        stack.m_85841_(this.size, this.size, this.size);
        VFXHelper.alignVertical(stack, this.disp);
        Matrix4f pose = stack.m_85850_().m_252922_();
        Vector3f norm = VFXHelper.normal(stack);
        Vector4f start = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f).mul((Matrix4fc)pose);
        Vector4f end = new Vector4f(0.0f, -Math.min(dist / this.size, 3.0f), 0.0f, 1.0f).mul((Matrix4fc)pose);
        Vector2f perp = VFXHelper.axialPerp(start, end, 1.0f);
        float w = 0.12f * this.size;
        float xs = perp.x * w;
        float ys = perp.y * w;
        consumer = buffer.m_6299_(RenderTypes.FLAT_TRANSLUCENT);
        new VFXHelper.VFXNode(start.x() + xs, start.x() - xs, start.y() + ys, start.y() - ys, start.z(), w).renderStart(norm, consumer, packedLight, this.c1);
        new VFXHelper.VFXNode(end.x(), end.x(), end.y(), end.y(), end.z(), w * 0.1f).renderEnd(norm, consumer, packedLight, this.c1);
        if (!this.c0.sameRGB(this.c1)) {
            buffer.m_6299_(RenderTypes.LINEAR_GLOW);
            buffer.m_6299_(RenderTypes.FLAT_TRANSLUCENT);
        }
        RenderHelper.renderBipyramid(stack, consumer, packedLight, this.c0, 4, 0.6f, 0.1f);
        buffer.m_6299_(RenderTypes.LINEAR_GLOW);
        buffer.m_6299_(RenderTypes.FLAT_TRANSLUCENT);
        RenderHelper.renderBipyramid(stack, consumer, packedLight, this.c0.mix(Color.WHITE, 0.5f), 4, 0.4f, 0.066f);
    }

    @Nonnull
    public static ParticleProvider<BiColorParticleOptions> factory(SpriteSet spriteSet) {
        return ShardParticle::new;
    }
}

