/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.renderer.entity;

import cofh.core.common.entity.ElectricField;
import cofh.lib.client.renderer.entity.ITranslucentRenderer;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.SplittableRandom;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class ElectricFieldRenderer
extends EntityRenderer<ElectricField>
implements ITranslucentRenderer {
    public static final ResourceLocation[] TEXTURES = (ResourceLocation[])IntStream.range(0, 5).mapToObj(i -> new ResourceLocation("cofh_core", "textures/particle/plasma_ball_" + i + ".png")).toArray(ResourceLocation[]::new);

    public ElectricFieldRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(ElectricField entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.m_85836_();
        int time = MathHelper.floor(((float)entity.f_19797_ + partialTicks) * 0.75f);
        SplittableRandom rand = new SplittableRandom((long)time * 69420L);
        float rot = rand.nextFloat((float)Math.PI * 2);
        packedLight = 0xF000F0;
        Vector4f center = new Vector4f(0.0f, entity.m_20192_(), 0.0f, 1.0f).mul((Matrix4fc)stack.m_85850_().m_252922_());
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
        float x = center.x();
        float y = center.y();
        float z = center.z() + 0.1f;
        float sin = MathHelper.sin(rot);
        float cos = MathHelper.cos(rot);
        float w = 0.5f;
        float a = w * (cos - sin);
        float b = w * (sin + cos);
        Vector3f normal = new Vector3f(0.0f, 1.0f, 0.0f).mul((Matrix3fc)stack.m_85850_().m_252943_());
        float nx = normal.x();
        float ny = normal.y();
        float nz = normal.z();
        consumer.m_5483_((double)(x + a), (double)(y + b), (double)z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(nx, ny, nz).m_5752_();
        consumer.m_5483_((double)(x - b), (double)(y + a), (double)z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(nx, ny, nz).m_5752_();
        consumer.m_5483_((double)(x - a), (double)(y - b), (double)z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(nx, ny, nz).m_5752_();
        consumer.m_5483_((double)(x + b), (double)(y - a), (double)z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(nx, ny, nz).m_5752_();
        stack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, stack, buffer, packedLight);
    }

    public boolean shouldRender(ElectricField entity, Frustum clip, double x, double y, double z) {
        return super.m_5523_((Entity)entity, clip, x, y, z);
    }

    public ResourceLocation getTextureLocation(ElectricField entity) {
        return TEXTURES[entity.getTextureIndex(TEXTURES.length)];
    }
}

