/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.capability.templates;

import cofh.core.common.capability.CapabilityArchery;
import cofh.core.util.helpers.ArcheryHelper;
import cofh.lib.api.capability.IArcheryAmmoItem;
import cofh.lib.util.Utils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class ArcheryAmmoItemWrapper
implements IArcheryAmmoItem,
ICapabilityProvider {
    private final LazyOptional<IArcheryAmmoItem> holder = LazyOptional.of(() -> this);
    final ItemStack ammoItem;

    public ArcheryAmmoItemWrapper(ItemStack ammoItem) {
        this.ammoItem = ammoItem;
    }

    @Override
    public void onArrowLoosed(Player shooter) {
        this.ammoItem.m_41774_(1);
    }

    @Override
    public AbstractArrow createArrowEntity(Level world, Player shooter) {
        return ArcheryHelper.createDefaultArrow(world, this.ammoItem, shooter);
    }

    @Override
    public boolean isEmpty(Player shooter) {
        return this.ammoItem.m_41619_();
    }

    @Override
    public boolean isInfinite(ItemStack bow, Player shooter) {
        return shooter != null && shooter.m_150110_().f_35937_ || Utils.getItemEnchantmentLevel(Enchantments.f_44952_, bow) > 0 && this.ammoItem.m_41720_().getClass() == ArrowItem.class;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityArchery.AMMO_ITEM_CAPABILITY.orEmpty(cap, this.holder);
    }
}

