/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.event;

import cofh.core.common.capability.CapabilityAreaEffect;
import cofh.core.common.capability.templates.AreaEffectItemWrapper;
import cofh.core.util.helpers.AreaEffectHelper;
import cofh.lib.api.capability.IAreaEffectItem;
import cofh.lib.util.Utils;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cofh_core")
public class AreaEffectEvents {
    private static final Set<BlockPos> HARVESTED_BLOCKS = new ObjectOpenHashSet();

    private AreaEffectEvents() {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleBlockBreakEvent(BlockEvent.BreakEvent event) {
        ServerPlayer player;
        block7: {
            block6: {
                Player player2 = event.getPlayer();
                if (!(player2 instanceof ServerPlayer)) break block6;
                player = (ServerPlayer)player2;
                if (!Utils.isClientWorld(player.f_19853_)) break block7;
            }
            return;
        }
        BlockPos origin = event.getPos();
        if (AreaEffectEvents.isAreaHarvested(origin)) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (!AreaEffectHelper.validAreaEffectMiningItem(stack)) {
            return;
        }
        ImmutableList<BlockPos> areaBlocks = ((IAreaEffectItem)stack.getCapability(CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY).orElse((Object)new AreaEffectItemWrapper(stack))).getAreaEffectBlocks(origin, (Player)player);
        for (BlockPos pos : areaBlocks) {
            if (stack.m_41619_()) break;
            HARVESTED_BLOCKS.add(pos);
            player.f_8941_.m_9280_(pos);
            HARVESTED_BLOCKS.remove(pos);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void handleBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        ItemStack stack = player.m_21205_();
        if (!AreaEffectHelper.validAreaEffectMiningItem(stack)) {
            return;
        }
        event.getPosition().ifPresent(pos -> {
            ImmutableList<BlockPos> areaBlocks = ((IAreaEffectItem)stack.getCapability(CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY).orElse((Object)new AreaEffectItemWrapper(stack))).getAreaEffectBlocks((BlockPos)pos, player);
            float curHardness = event.getState().m_60800_((BlockGetter)player.f_19853_, pos);
            if (curHardness <= 0.0f || areaBlocks.size() <= 1) {
                return;
            }
            float areaMod = Mth.m_14036_((float)(1.0f - 0.01f * (float)areaBlocks.size()), (float)0.1f, (float)1.0f);
            event.setNewSpeed(event.getNewSpeed() * areaMod);
            float maxHardness = AreaEffectEvents.getMaxHardness((BlockGetter)player.f_19853_, areaBlocks, curHardness);
            if (maxHardness > curHardness) {
                event.setNewSpeed(event.getNewSpeed() * curHardness / maxHardness);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleTickEndEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            HARVESTED_BLOCKS.clear();
        }
    }

    public static boolean isAreaHarvested(BlockPos pos) {
        return HARVESTED_BLOCKS.contains(pos);
    }

    private static float getMaxHardness(BlockGetter world, List<BlockPos> areaBlocks, float curHardness) {
        float maxHardness = curHardness;
        for (BlockPos pos : areaBlocks) {
            float testHardness = world.m_8055_(pos).m_60800_(world, pos);
            if (!(testHardness > maxHardness)) continue;
            maxHardness = testHardness;
        }
        return maxHardness;
    }

    private static UseOnContext getContextAt(UseOnContext context, BlockPos pos) {
        BlockPos og = context.m_8083_();
        Vec3 loc = context.m_43720_().m_82520_((double)(pos.m_123341_() - og.m_123341_()), (double)(pos.m_123342_() - og.m_123342_()), (double)(pos.m_123343_() - og.m_123343_()));
        return new CoFHIgnoreUseOnContext(context.m_43725_(), context.m_43723_(), context.m_43724_(), context.m_43722_(), new BlockHitResult(loc, context.m_43719_(), pos, context.m_43721_()));
    }

    private static class CoFHIgnoreUseOnContext
    extends UseOnContext {
        public CoFHIgnoreUseOnContext(Player player, InteractionHand hand, BlockHitResult result) {
            super(player, hand, result);
        }

        public CoFHIgnoreUseOnContext(Level level, @Nullable Player player, InteractionHand hand, ItemStack stack, BlockHitResult result) {
            super(level, player, hand, stack, result);
        }

        public static UseOnContext copy(UseOnContext context) {
            return new CoFHIgnoreUseOnContext(context.m_43725_(), context.m_43723_(), context.m_43724_(), context.m_43722_(), new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), context.m_43721_()));
        }
    }
}

