/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.inventory;

import cofh.core.util.helpers.InventoryHelper;
import cofh.lib.common.inventory.SlotCoFH;
import cofh.lib.common.inventory.SlotFalseCopy;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class ContainerMenuCoFH
extends AbstractContainerMenu {
    protected boolean allowSwap = true;
    protected boolean falseSlotSupport = true;
    protected boolean syncing = false;
    protected Player player;
    protected List<SlotCoFH> augmentSlots = new ArrayList<SlotCoFH>();

    public ContainerMenuCoFH(@Nullable MenuType<?> type, int id, Inventory inventory, Player player) {
        super(type, id);
        this.player = player;
    }

    public final int getNumAugmentSlots() {
        return this.augmentSlots.size();
    }

    public final List<SlotCoFH> getAugmentSlots() {
        return this.augmentSlots;
    }

    protected void bindAugmentSlots(Container inventory, int startIndex, int numSlots) {
        for (int i = 0; i < numSlots; ++i) {
            SlotCoFH slot = new SlotCoFH(inventory, i + startIndex, 0, 0, 1);
            this.augmentSlots.add(slot);
            this.m_38897_(slot);
        }
        ((ArrayList)this.augmentSlots).trimToSize();
    }

    protected void bindPlayerInventory(Inventory inventory) {
        int i;
        int xOffset = this.getPlayerInventoryHorizontalOffset();
        int yOffset = this.getPlayerInventoryVerticalOffset();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, xOffset + i * 18, yOffset + 58));
        }
    }

    protected int getPlayerInventoryHorizontalOffset() {
        return 8;
    }

    protected int getPlayerInventoryVerticalOffset() {
        return 84;
    }

    protected abstract int getMergeableSlotCount();

    protected boolean supportsShiftClick(Player player, int index) {
        return true;
    }

    protected boolean performMerge(int index, ItemStack stack) {
        int invBase = this.getMergeableSlotCount();
        int invFull = this.f_38839_.size();
        int invHotbar = invFull - 9;
        int invPlayer = invHotbar - 27;
        if (index < invPlayer) {
            return this.m_38903_(stack, invPlayer, invFull, false);
        }
        return this.m_38903_(stack, 0, invBase, false);
    }

    public FriendlyByteBuf getConfigPacket(FriendlyByteBuf buffer) {
        return buffer;
    }

    public void handleConfigPacket(FriendlyByteBuf buffer) {
    }

    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        return buffer;
    }

    public void handleGuiPacket(FriendlyByteBuf buffer) {
    }

    public ItemStack m_7648_(Player player, int index) {
        if (!this.supportsShiftClick(player, index)) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stackInSlot = slot.m_7993_();
            stack = stackInSlot.m_41777_();
            if (!this.performMerge(index, stackInSlot)) {
                return ItemStack.f_41583_;
            }
            slot.m_40234_(stackInSlot, stack);
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stackInSlot.m_41613_() == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stackInSlot);
        }
        return stack;
    }

    public void m_150399_(int index, int dragType, ClickType clickTypeIn, Player player) {
        if (clickTypeIn == ClickType.SWAP && !this.allowSwap) {
            return;
        }
        if (this.falseSlotSupport) {
            Slot slot;
            Slot slot2 = slot = index < 0 ? null : (Slot)this.f_38839_.get(index);
            if (slot instanceof SlotFalseCopy) {
                if (dragType == 2) {
                    slot.m_5852_(ItemStack.f_41583_);
                } else {
                    slot.m_5852_(this.m_142621_().m_41619_() ? ItemStack.f_41583_ : this.m_142621_().m_41777_());
                }
                return;
            }
        }
        super.m_150399_(index, dragType, clickTypeIn, player);
    }

    public void m_182410_(int p_182411_, List<ItemStack> p_182412_, ItemStack p_182413_) {
        this.syncing = true;
        super.m_182410_(p_182411_, p_182412_, p_182413_);
        this.syncing = false;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return InventoryHelper.mergeItemStack((List<Slot>)this.f_38839_, stack, startIndex, endIndex, reverseDirection);
    }
}

