/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.network.packet.client;

import cofh.core.CoFHCore;
import cofh.core.util.ProxyUtils;
import cofh.lib.common.network.packet.IPacketClient;
import cofh.lib.common.network.packet.PacketBase;
import cofh.lib.util.Utils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class EffectAddedPacket
extends PacketBase
implements IPacketClient {
    protected int id;
    protected MobEffectInstance effect;

    public EffectAddedPacket() {
        super(96, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleClient() {
        if (this.effect == null) {
            return;
        }
        Level level = ProxyUtils.getClientWorld();
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(this.id);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!entity.equals((Object)ProxyUtils.getClientPlayer())) {
                living.m_147215_(this.effect, null);
            }
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.id);
        buf.m_130085_(Utils.getRegistryName(this.effect.m_19544_()));
        buf.writeInt(this.effect.m_19557_());
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.id = buf.m_130242_();
        MobEffect effectType = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(buf.m_130281_());
        int duration = buf.readInt();
        if (effectType != null) {
            this.effect = new MobEffectInstance(effectType, duration);
        }
    }

    public static void sendToClient(LivingEntity entity, MobEffectInstance effect) {
        if (!entity.f_19853_.f_46443_) {
            EffectAddedPacket packet = new EffectAddedPacket();
            packet.id = entity.m_19879_();
            packet.effect = effect;
            packet.sendToAllAround(entity.m_20182_(), 192.0, (ResourceKey<Level>)entity.f_19853_.m_46472_());
        }
    }

    public static void sendToClient(LivingEntity entity, MobEffectInstance effect, Player client) {
        if (!entity.f_19853_.f_46443_ && client instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)client;
            EffectAddedPacket packet = new EffectAddedPacket();
            packet.id = entity.m_19879_();
            packet.effect = effect;
            packet.sendToPlayer(player);
        }
    }
}

