/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.network.packet.server;

import cofh.core.CoFHCore;
import cofh.core.common.item.IEntityRayTraceItem;
import cofh.core.util.ProxyUtils;
import cofh.lib.common.network.packet.IPacketServer;
import cofh.lib.common.network.packet.PacketBase;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ItemRayTraceEntityPacket
extends PacketBase
implements IPacketServer {
    protected InteractionHand hand;
    protected Vec3 origin;
    protected int targetId;
    protected Vec3 offset;
    protected float power;

    public ItemRayTraceEntityPacket() {
        super(67, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayer player) {
        ItemStack stack = player.m_21120_(this.hand);
        Item item = stack.m_41720_();
        if (item instanceof IEntityRayTraceItem) {
            IEntityRayTraceItem item2 = (IEntityRayTraceItem)item;
            Entity target = player.f_19853_.m_6815_(this.targetId);
            if (target != null) {
                item2.handleEntityRayTrace(player.m_284548_(), player, this.hand, stack, this.origin, target, target.m_20182_().m_82549_(this.offset), this.power);
            }
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.hand);
        buf.writeDouble(this.origin.f_82479_);
        buf.writeFloat((float)this.origin.f_82480_);
        buf.writeDouble(this.origin.f_82481_);
        buf.writeInt(this.targetId);
        buf.writeFloat((float)this.offset.f_82479_);
        buf.writeFloat((float)this.offset.f_82480_);
        buf.writeFloat((float)this.offset.f_82481_);
        buf.writeFloat(this.power);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
        this.origin = new Vec3(buf.readDouble(), (double)buf.readFloat(), buf.readDouble());
        this.targetId = buf.readInt();
        this.offset = new Vec3((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
        this.power = buf.readFloat();
    }

    public static void sendToServer(Player player, InteractionHand hand, Vec3 origin, Entity target, Vec3 hit, float power) {
        Player client;
        if (player.f_19853_.f_46443_ && (client = ProxyUtils.getClientPlayer()) != null && client.equals((Object)player)) {
            ItemRayTraceEntityPacket packet = new ItemRayTraceEntityPacket();
            packet.hand = hand;
            packet.origin = origin;
            packet.targetId = target.m_19879_();
            packet.offset = hit.m_82546_(target.m_20182_());
            packet.power = power;
            packet.sendToServer();
        }
    }
}

