/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.util.filter.EmptyFilter;
import cofh.core.util.filter.FilterHolderType;
import cofh.core.util.filter.IFilter;
import cofh.core.util.filter.IFilterable;
import cofh.core.util.helpers.AugmentableHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkHooks;

public final class FilterHelper {
    private FilterHelper() {
    }

    public static boolean hasFilter(ItemStack stack) {
        return !FilterHelper.getFilterType(stack).isEmpty();
    }

    public static String getFilterType(ItemStack stack) {
        return AugmentableHelper.getPropertyWithDefault(stack, "FilterType", "");
    }

    public static boolean hasFilter(IFilterable filterable) {
        IFilter filter = filterable.getFilter();
        return filter != null && filter != EmptyFilter.INSTANCE;
    }

    public static boolean hasFilter(BlockEntity tile) {
        if (tile instanceof IFilterable) {
            IFilterable filterable = (IFilterable)tile;
            IFilter filter = filterable.getFilter();
            return filter != null && filter != EmptyFilter.INSTANCE;
        }
        return false;
    }

    public static boolean hasFilter(Entity entity) {
        if (entity instanceof IFilterable) {
            IFilterable filterable = (IFilterable)entity;
            IFilter filter = filterable.getFilter();
            return filter != null && filter != EmptyFilter.INSTANCE;
        }
        return false;
    }

    public static void openItemScreen(ServerPlayer player, MenuProvider containerSupplier) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)containerSupplier, buf -> {
            buf.m_130130_(FilterHolderType.ITEM.ordinal());
            buf.m_130130_(-1);
            buf.m_130064_(BlockPos.f_121853_);
        });
    }

    public static void openTileScreen(ServerPlayer player, MenuProvider containerSupplier, BlockPos pos) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)containerSupplier, buf -> {
            buf.m_130130_(FilterHolderType.TILE.ordinal());
            buf.m_130130_(-1);
            buf.m_130064_(pos);
        });
    }

    public static void openEntityScreen(ServerPlayer player, MenuProvider containerSupplier, int entityId) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)containerSupplier, buf -> {
            buf.m_130130_(FilterHolderType.ENTITY.ordinal());
            buf.m_130130_(entityId);
            buf.m_130064_(BlockPos.f_121853_);
        });
    }
}

