/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.crafting;

import cofh.lib.util.Utils;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ComparableItemStack {
    private final Item item;
    private int stackSize;

    public ComparableItemStack(ItemStack stack) {
        this.item = stack.m_41720_();
        if (!stack.m_41619_()) {
            this.stackSize = stack.m_41613_();
        }
    }

    public ComparableItemStack(Item item, int stackSize) {
        this.item = item;
        this.stackSize = stackSize;
    }

    public ComparableItemStack(ComparableItemStack other) {
        this.item = other.item;
        this.stackSize = other.stackSize;
    }

    protected boolean isItemEqual(ComparableItemStack other) {
        return other != null && this.item == other.item;
    }

    public boolean isStackEqual(ComparableItemStack other) {
        return this.isItemEqual(other) && this.stackSize == other.stackSize;
    }

    public int getId() {
        return Item.m_41393_((Item)this.item);
    }

    public ItemStack toItemStack() {
        return this.item != Items.f_41852_ ? new ItemStack((ItemLike)this.item, this.stackSize) : ItemStack.f_41583_;
    }

    public boolean equals(Object o) {
        return o instanceof ComparableItemStack && this.isItemEqual((ComparableItemStack)o);
    }

    public int hashCode() {
        return this.item.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(768);
        builder.append(this.getClass().getName()).append('@');
        builder.append(System.identityHashCode(this)).append('{');
        builder.append("ID:").append(this.getId()).append(", ");
        builder.append("ITM:");
        if (this.item == null) {
            builder.append("null");
        } else {
            builder.append(this.item.getClass().getName()).append('@');
            builder.append(System.identityHashCode(this.item)).append(' ');
            builder.append('[').append(Utils.getRegistryName(this.item)).append(']');
        }
        builder.append('}');
        return builder.toString();
    }
}

