/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.client.gui.screens;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.phosphophyllite.client.gui.RenderHelper;
import net.roguelogix.phosphophyllite.client.gui.api.IRender;
import net.roguelogix.phosphophyllite.client.gui.api.ITooltip;
import net.roguelogix.phosphophyllite.client.gui.elements.AbstractElement;

@OnlyIn(value=Dist.CLIENT)
public class PhosphophylliteScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements MenuAccess<T> {
    private final List<AbstractElement> screenElements;
    protected ResourceLocation textureAtlas;
    protected Inventory inventory;

    public PhosphophylliteScreen(T screenContainer, Inventory playerInventory, Component title, ResourceLocation textureAtlas, int width, int height) {
        super(screenContainer, playerInventory, title);
        this.inventory = playerInventory;
        this.textureAtlas = textureAtlas;
        this.f_97726_ = width;
        this.f_97727_ = height;
        this.screenElements = Lists.newArrayList();
    }

    public void addScreenElement(AbstractElement element) {
        if (element != null) {
            this.screenElements.add(element);
        }
    }

    public int getWidth() {
        return this.f_96543_;
    }

    public int getHeight() {
        return this.f_96544_;
    }

    public Font getFont() {
        return this.f_96547_;
    }

    public void setTextureAtlas(ResourceLocation textureAtlas) {
        this.textureAtlas = textureAtlas;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        for (AbstractElement element : this.screenElements) {
            if (!(element instanceof ITooltip)) continue;
            ((ITooltip)((Object)element)).renderTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    public void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        RenderHelper.bindTexture(this.textureAtlas);
        RenderHelper.setRenderColor(1.0f, 1.0f, 1.0f, 1.0f);
        for (AbstractElement element : this.screenElements) {
            if (!(element instanceof IRender)) continue;
            ((IRender)((Object)element)).render(guiGraphics, mouseX, mouseY);
        }
        guiGraphics.m_280056_(this.f_96547_, this.f_96539_.getString(), this.f_97728_, this.f_97729_, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderHelper.bindTexture(this.textureAtlas);
        RenderHelper.setRenderColor(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_280218_(this.textureAtlas, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
    }

    public boolean isMouseOver(double mouseX, double mouseY, double areaX, double areaY, int areaWidth, int areaHeight) {
        int relativeX = (int)((double)this.getGuiLeft() + areaX);
        int relativeY = (int)((double)this.getGuiTop() + areaY);
        return mouseX > (double)relativeX && mouseX < (double)(relativeX + areaWidth) && mouseY > (double)relativeY && mouseY < (double)(relativeY + areaHeight);
    }

    public void m_181908_() {
        for (AbstractElement element : this.screenElements) {
            element.m_7673_();
        }
    }

    public void m_94757_(double mouseX, double mouseY) {
        for (AbstractElement element : this.screenElements) {
            if (element == null) continue;
            element.m_94757_(mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean handled = false;
        for (AbstractElement element : this.screenElements) {
            if (element == null) continue;
            handled = handled || element.m_6375_(mouseX, mouseY, button);
        }
        return handled || super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        boolean handled = false;
        for (AbstractElement element : this.screenElements) {
            if (element == null) continue;
            handled = handled || element.m_6348_(mouseX, mouseY, button);
        }
        return handled || super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean handled = false;
        for (AbstractElement element : this.screenElements) {
            if (element == null) continue;
            handled = handled || element.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return handled || super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean handled = false;
        for (AbstractElement element : this.screenElements) {
            if (element == null) continue;
            handled = handled || element.m_6050_(mouseX, mouseY, delta);
        }
        return handled || super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean handled = false;
        for (AbstractElement element : this.screenElements) {
            if (element == null) continue;
            handled = handled || element.m_7933_(keyCode, scanCode, modifiers);
        }
        return handled || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        boolean handled = false;
        for (AbstractElement element : this.screenElements) {
            if (element == null) continue;
            handled = handled || element.m_7920_(keyCode, scanCode, modifiers);
        }
        return handled || super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        boolean handled = false;
        for (AbstractElement element : this.screenElements) {
            if (element == null) continue;
            handled = handled || element.m_5534_(codePoint, modifiers);
        }
        return handled || super.m_5534_(codePoint, modifiers);
    }
}

