/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.config.spec;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.roguelogix.phosphophyllite.config.ConfigType;
import net.roguelogix.phosphophyllite.config.ConfigValue;
import net.roguelogix.phosphophyllite.config.spec.ConfigOptionsDefaults;
import net.roguelogix.phosphophyllite.config.spec.ConfigSpecUtil;
import net.roguelogix.phosphophyllite.config.spec.SpecBoolNode;
import net.roguelogix.phosphophyllite.config.spec.SpecEnumNode;
import net.roguelogix.phosphophyllite.config.spec.SpecFloatNode;
import net.roguelogix.phosphophyllite.config.spec.SpecIntegralNode;
import net.roguelogix.phosphophyllite.config.spec.SpecNode;
import net.roguelogix.phosphophyllite.config.spec.SpecResourceLocationNode;
import net.roguelogix.phosphophyllite.config.spec.SpecStringNode;
import net.roguelogix.phosphophyllite.parsers.Element;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@NonnullDefault
public class SpecObjectNode
extends SpecNode {
    @Nullable
    public SpecObjectNode parent;
    private final Object object;
    @Nullable
    private final Field field;
    private Object activeObject;
    public final Map<String, SpecNode> subNodes;
    public final List<SpecNode> subNodeList;

    private SpecObjectNode(SpecObjectNode parent, Field field, ConfigType type, ConfigOptionsDefaults defaults) {
        defaults = defaults.transform(field.getAnnotation(ConfigValue.class));
        super(field.getName(), field.getAnnotation(ConfigValue.class), defaults);
        this.parent = parent;
        this.field = field;
        try {
            this.object = field.get(parent.object);
            if (this.object == null) {
                throw new IllegalArgumentException();
            }
            this.activeObject = this.object;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        this.subNodeList = Collections.unmodifiableList(this.readObjectSubNodes(type, defaults));
        this.subNodes = this.subNodeList.stream().collect(Collectors.toUnmodifiableMap(node -> Objects.requireNonNull(node.name), node -> node));
    }

    public SpecObjectNode(Object rootObject, String comment, ConfigType type, ConfigOptionsDefaults defaults) {
        super(null, comment, defaults.advanced(), defaults.hidden(), defaults.reloadable());
        this.activeObject = this.object = rootObject;
        this.field = null;
        List<SpecNode> modifiableSubNodes = this.readObjectSubNodes(type, defaults);
        modifiableSubNodes.add(0, new EnableAdvancedNode());
        this.subNodeList = Collections.unmodifiableList(modifiableSubNodes);
        this.subNodes = this.subNodeList.stream().collect(Collectors.toUnmodifiableMap(node -> node.name, node -> node));
    }

    public Object object() {
        return this.activeObject;
    }

    public void resetObject() {
        boolean reset = this.setActiveObject(this.object);
        if (!reset) {
            throw new IllegalStateException("Failed to reset to previous active object");
        }
    }

    public boolean setActiveObject(@Nullable Object newObject) {
        if (newObject == null) {
            this.resetObject();
            return true;
        }
        if (newObject.getClass() != this.object.getClass()) {
            return false;
        }
        for (SpecNode subNode : this.subNodeList) {
            if (!(subNode instanceof SpecObjectNode)) continue;
            SpecObjectNode subObjectNode = (SpecObjectNode)subNode;
            if (subObjectNode.field == null) {
                throw new IllegalStateException();
            }
            try {
                Object newSubObject = subObjectNode.field.get(newObject);
                if (subObjectNode.setActiveObject(newSubObject)) continue;
                boolean reset = this.setActiveObject(this.activeObject);
                if (!reset) {
                    throw new IllegalStateException("Failed to reset to previous active object");
                }
                return false;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.activeObject = newObject;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<SpecNode> readObjectSubNodes(ConfigType type, ConfigOptionsDefaults defaults) {
        ObjectArrayList subNodes = new ObjectArrayList();
        Class<?> objectClazz = this.object.getClass();
        for (Field objectField : objectClazz.getDeclaredFields()) {
            void var11_11;
            if (!objectField.isAnnotationPresent(ConfigValue.class)) continue;
            objectField.setAccessible(true);
            ConfigValue fieldAnnotation = objectField.getAnnotation(ConfigValue.class);
            Class<?> fieldClazz = objectField.getType();
            if (fieldClazz == String.class) {
                SpecStringNode specStringNode = new SpecStringNode(this, objectField, defaults);
            } else if (fieldClazz == ResourceLocation.class) {
                SpecResourceLocationNode specResourceLocationNode = new SpecResourceLocationNode(this, objectField, defaults);
            } else if (fieldClazz.isPrimitive() || Boolean.class.isAssignableFrom(fieldClazz) || Number.class.isAssignableFrom(fieldClazz)) {
                if (fieldClazz == Boolean.TYPE || fieldClazz == Boolean.class) {
                    SpecBoolNode specBoolNode = new SpecBoolNode(this, objectField, defaults);
                } else if (ConfigSpecUtil.isIntegral(fieldClazz)) {
                    SpecIntegralNode specIntegralNode = new SpecIntegralNode(this, objectField, defaults);
                } else {
                    if (!ConfigSpecUtil.isFloat(fieldClazz)) throw new IllegalArgumentException("Unknown primitive field type " + fieldClazz.getSimpleName());
                    SpecFloatNode specFloatNode = new SpecFloatNode(this, objectField, defaults);
                }
            } else if (fieldClazz.isEnum()) {
                SpecEnumNode specEnumNode = new SpecEnumNode(this, objectField, defaults);
            } else {
                SpecObjectNode specObjectNode = new SpecObjectNode(this, objectField, type, defaults);
                if (specObjectNode.subNodeList.isEmpty()) continue;
            }
            if (!(var11_11 instanceof SpecObjectNode) && fieldAnnotation.configType().from(defaults.type()) != type) continue;
            subNodes.add((Object)var11_11);
        }
        return subNodes;
    }

    @Override
    public void writeDefault() {
        this.subNodeList.forEach(SpecNode::writeDefault);
    }

    @Override
    @Nullable
    public Element generateDefaultElement() {
        return this.generateDefaultElement(false);
    }

    @Nullable
    public Element generateDefaultElement(boolean advanced) {
        Element[] subElements = (Element[])this.subNodeList.stream().filter(specNode -> !specNode.hidden).map(specNode -> {
            if (specNode instanceof SpecObjectNode) {
                SpecObjectNode objectNode = (SpecObjectNode)specNode;
                return objectNode.generateDefaultElement(advanced);
            }
            if (!advanced && specNode.advanced) {
                return null;
            }
            return specNode.generateDefaultElement();
        }).filter(Objects::nonNull).toArray(Element[]::new);
        if (subElements.length == 0) {
            return null;
        }
        return new Element(Element.Type.Map, this.baseComment, this.name, subElements);
    }

    @Override
    @Nullable
    public Element generateCurrentElement() {
        return this.generateCurrentElement(false);
    }

    @Nullable
    public Element generateCurrentElement(boolean advanced) {
        Element[] subElements = (Element[])this.subNodeList.stream().filter(specNode -> !specNode.hidden).map(specNode -> {
            if (specNode instanceof SpecObjectNode) {
                SpecObjectNode objectNode = (SpecObjectNode)specNode;
                return objectNode.generateCurrentElement(advanced);
            }
            if (!advanced && specNode.advanced) {
                return null;
            }
            return specNode.generateCurrentElement();
        }).filter(Objects::nonNull).toArray(Element[]::new);
        if (subElements.length == 0) {
            return null;
        }
        return new Element(Element.Type.Map, this.baseComment, this.name, subElements);
    }

    @Override
    public Element generateSyncElement() {
        Element[] subElements = (Element[])this.subNodeList.stream().map(SpecNode::generateSyncElement).toArray(Element[]::new);
        return new Element(Element.Type.Map, null, this.name, subElements);
    }

    @Override
    @Nullable
    public Element correctToValidState(Element element) {
        if (element.type != Element.Type.Map || element.subArray == null) {
            return this.generateDefaultElement(false);
        }
        Element[] subElements = (Element[])Arrays.stream(element.subArray).map(subElement -> {
            SpecNode node = this.subNodes.get(subElement.name);
            if (node == null) {
                return null;
            }
            return node.correctToValidState((Element)subElement);
        }).filter(Objects::nonNull).toArray(Element[]::new);
        if (subElements.length == 0) {
            return null;
        }
        return new Element(Element.Type.Map, this.baseComment, this.name, subElements);
    }

    @Override
    public void writeElement(Element element) {
        if (element.subArray == null) {
            return;
        }
        for (Element value : element.subArray) {
            SpecNode subNode = this.subNodes.get(value.name);
            if (subNode == null) continue;
            subNode.writeElement(value);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Element regenerateMissingElements(Element element) {
        boolean bl;
        SpecNode specNode = this.subNodes.get("EnableAdvancedConfig");
        if (specNode instanceof EnableAdvancedNode) {
            EnableAdvancedNode eaNode = (EnableAdvancedNode)specNode;
            if (eaNode.advancedEnabled) {
                bl = true;
                return this.regenerateMissingElements(element, bl);
            }
        }
        bl = false;
        return this.regenerateMissingElements(element, bl);
    }

    private Element regenerateMissingElements(Element element, boolean enableAdvanced) {
        int j;
        assert (element.subArray != null);
        ObjectArrayList newElements = new ObjectArrayList();
        block0: for (Map.Entry<String, SpecNode> entry : this.subNodes.entrySet()) {
            SpecNode node = entry.getValue();
            if (node.hidden || node.advanced && !enableAdvanced) continue;
            String name = entry.getKey();
            for (Element value : element.subArray) {
                if (name.equals(value.name)) continue block0;
            }
            Element newElement = node.generateDefaultElement();
            if (newElement == null) continue;
            newElements.add((Object)newElement);
        }
        Element[] subElements = new Element[element.subArray.length + newElements.size()];
        int i = 0;
        for (j = 0; j < element.subArray.length; ++j) {
            Element subElement = element.subArray[j];
            SpecNode subNode = this.subNodes.get(subElement.name);
            if (subNode instanceof SpecObjectNode) {
                SpecObjectNode objectNode = (SpecObjectNode)subNode;
                subElement = objectNode.regenerateMissingElements(subElement, enableAdvanced);
            } else {
                assert (subElement.value != null);
                subElement = new Element(subElement.type, Objects.requireNonNull(subNode.generateDefaultElement()).comment, subElement.name, subElement.value);
            }
            subElements[i] = subElement;
            ++i;
        }
        for (j = 0; j < newElements.size(); ++j) {
            subElements[i] = (Element)newElements.get(j);
            ++i;
        }
        return new Element(Element.Type.Map, this.baseComment, this.name, subElements);
    }

    @Nullable
    public Element removeUnknownElements(Element element) {
        ObjectArrayList retainedElements = new ObjectArrayList();
        assert (element.subArray != null);
        for (Element value : element.subArray) {
            SpecNode subNode = this.subNodes.get(value.name);
            if (subNode == null) continue;
            if (subNode instanceof SpecObjectNode) {
                SpecObjectNode objectNode = (SpecObjectNode)subNode;
                value = objectNode.removeUnknownElements(value);
            }
            if (value == null) continue;
            retainedElements.add((Object)value);
        }
        if (retainedElements.isEmpty()) {
            return null;
        }
        return new Element(Element.Type.Map, element.comment, this.name, (Element[])retainedElements.toArray((Object[])new Element[0]));
    }

    public Element correctElementOrder(Element element) {
        Map<String, Element> elementMap = Arrays.stream(element.subArray).collect(Collectors.toMap(node -> node.name, node -> node));
        Element[] newElementArray = new Element[element.subArray.length];
        int i = 0;
        for (SpecNode specNode : this.subNodeList) {
            Element subElement = elementMap.remove(specNode.name);
            if (subElement == null) continue;
            if (specNode instanceof SpecObjectNode) {
                SpecObjectNode objectNode = (SpecObjectNode)specNode;
                subElement = objectNode.correctElementOrder(subElement);
            }
            newElementArray[i++] = subElement;
        }
        if (i != newElementArray.length) {
            for (Element element2 : elementMap.values()) {
                newElementArray[i++] = element2;
            }
        }
        return new Element(element.type, element.comment, element.name, newElementArray);
    }

    @Nullable
    public Element trimToReloadable(Element element) {
        ObjectArrayList retainedElements = new ObjectArrayList();
        assert (element.subArray != null);
        for (Element value : element.subArray) {
            SpecNode subNode = this.subNodes.get(value.name);
            if (subNode == null) continue;
            if (subNode instanceof SpecObjectNode) {
                SpecObjectNode objectNode = (SpecObjectNode)subNode;
                value = objectNode.trimToReloadable(value);
            } else if (!subNode.reloadable) continue;
            if (value == null) continue;
            retainedElements.add((Object)value);
        }
        if (retainedElements.isEmpty()) {
            return null;
        }
        return new Element(Element.Type.Map, element.comment, this.name, (Element[])retainedElements.toArray((Object[])new Element[0]));
    }

    protected static class EnableAdvancedNode
    extends SpecNode {
        private boolean advancedEnabled;

        protected EnableAdvancedNode() {
            super("EnableAdvancedConfig", "EnableAdvancedConfig", false, false, true);
        }

        @Override
        public void writeDefault() {
            this.advancedEnabled = false;
        }

        @Override
        @Nullable
        public Element generateDefaultElement() {
            return new Element(Element.Type.Boolean, this.generateComment(), "EnableAdvancedConfig", false);
        }

        @Override
        public Element generateCurrentElement() {
            return new Element(Element.Type.Boolean, this.generateComment(), "EnableAdvancedConfig", this.advancedEnabled);
        }

        @Override
        public Element generateSyncElement() {
            return new Element(Element.Type.Boolean, null, "EnableAdvancedConfig", this.advancedEnabled);
        }

        public String generateComment() {
            return "Enabled advanced config options\nAdditional options will be shown after next config load";
        }

        @Override
        public Element correctToValidState(Element element) {
            if (element.type != Element.Type.Boolean || !(element.value instanceof Boolean)) {
                return this.generateDefaultElement();
            }
            return new Element(Element.Type.Boolean, Objects.requireNonNull(this.generateDefaultElement()).comment, this.name, element.asBool());
        }

        @Override
        public void writeElement(Element element) {
            this.advancedEnabled = element.asBool();
        }
    }
}

