/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.energy;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.roguelogix.phosphophyllite.energy.EnergyHandlerWrappers;
import net.roguelogix.phosphophyllite.energy.IPhosphophylliteEnergyHandler;
import net.roguelogix.phosphophyllite.modular.api.IModularTile;
import net.roguelogix.phosphophyllite.modular.api.ModuleRegistry;
import net.roguelogix.phosphophyllite.modular.api.TileModule;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import org.jetbrains.annotations.Nullable;

@NonnullDefault
public interface IEnergyTile
extends IModularTile {
    public LazyOptional<IPhosphophylliteEnergyHandler> energyHandler();

    default public LazyOptional<IPhosphophylliteEnergyHandler> findEnergyCapability(Direction direction) {
        return Objects.requireNonNull(this.module(IEnergyTile.class, Module.class)).findEnergyCapability(direction);
    }

    public static final class Module
    extends TileModule<IEnergyTile> {
        private LazyOptional<IPhosphophylliteEnergyHandler> baseHandler = LazyOptional.empty();
        private final Object2ObjectMap<Capability<?>, LazyOptional<?>> optionals = new Object2ObjectOpenHashMap();

        @OnModLoad
        private static void onModLoad() {
            ModuleRegistry.registerTileModule(IEnergyTile.class, Module::new);
        }

        public Module(IEnergyTile iface) {
            super(iface);
        }

        private void invalidate(LazyOptional<IPhosphophylliteEnergyHandler> ignored) {
            ObjectArrayList toInvalidate = new ObjectArrayList(this.optionals.values());
            this.optionals.clear();
            for (LazyOptional lazyOptional : toInvalidate) {
                lazyOptional.invalidate();
            }
        }

        private LazyOptional<IPhosphophylliteEnergyHandler> handler() {
            if (!this.baseHandler.isPresent()) {
                this.baseHandler = ((IEnergyTile)this.iface).energyHandler();
                this.baseHandler.addListener(this::invalidate);
            }
            return this.baseHandler;
        }

        @Override
        public <T> LazyOptional<T> capability(Capability<T> cap, @Nullable Direction side) {
            LazyOptional<?> optional = (LazyOptional<?>)this.optionals.get(cap);
            if (optional != null) {
                return optional.cast();
            }
            optional = EnergyHandlerWrappers.attemptWrap(cap, this.handler());
            if (optional.isPresent()) {
                this.optionals.put(cap, optional);
            }
            return optional.cast();
        }

        LazyOptional<IPhosphophylliteEnergyHandler> findEnergyCapability(Direction direction) {
            BlockEntity thisTile = ((IEnergyTile)this.iface).as(BlockEntity.class);
            BlockEntity tile = thisTile.m_58904_().m_7702_(thisTile.m_58899_().m_121955_(direction.m_122436_()));
            if (tile == null) {
                return LazyOptional.empty();
            }
            return EnergyHandlerWrappers.findCapability(tile, direction.m_122424_());
        }
    }
}

