/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.modular.api;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.roguelogix.phosphophyllite.modular.api.BlockModule;
import net.roguelogix.phosphophyllite.modular.api.IModularBlock;
import net.roguelogix.phosphophyllite.modular.api.IModularTile;
import net.roguelogix.phosphophyllite.modular.api.TileModule;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ModuleRegistry {
    private static final LinkedHashMap<Class<? extends IModularTile>, Function<BlockEntity, TileModule<?>>> tileModuleRegistry = new LinkedHashMap();
    private static final ArrayList<BiConsumer<Class<? extends IModularTile>, Function<BlockEntity, TileModule<?>>>> externalTileRegistrars = new ArrayList();
    private static final LinkedHashMap<Class<? extends IModularBlock>, Function<Block, BlockModule<?>>> blockModuleRegistry = new LinkedHashMap();
    private static final ArrayList<BiConsumer<Class<? extends IModularBlock>, Function<Block, BlockModule<?>>>> externalBlockRegistrars = new ArrayList();

    public static synchronized <T extends IModularTile> void registerTileModule(Class<T> moduleInterface, Function<T, TileModule<?>> constructor) {
        Function<BlockEntity, TileModule> wrapped = tile -> (TileModule)constructor.apply((IModularTile)tile);
        tileModuleRegistry.put(moduleInterface, wrapped);
        externalTileRegistrars.forEach((Consumer<BiConsumer<Class<IModularTile>, Function<BlockEntity, TileModule<?>>>>)((Consumer<BiConsumer>)c -> c.accept(moduleInterface, wrapped)));
    }

    public static synchronized <B extends IModularBlock> void registerBlockModule(Class<B> moduleInterface, Function<B, BlockModule<?>> constructor) {
        Function<Block, BlockModule> wrapped = block -> (BlockModule)constructor.apply((IModularBlock)block);
        blockModuleRegistry.put(moduleInterface, wrapped);
        externalBlockRegistrars.forEach((Consumer<BiConsumer<Class<IModularBlock>, Function<Block, BlockModule<?>>>>)((Consumer<BiConsumer>)c -> c.accept(moduleInterface, wrapped)));
    }

    public static synchronized void registerExternalRegistrar(BiConsumer<Class<? extends IModularTile>, Function<BlockEntity, TileModule<?>>> tileRegistrar, BiConsumer<Class<? extends IModularBlock>, Function<Block, BlockModule<?>>> blockRegistrar) {
        externalTileRegistrars.add(tileRegistrar);
        tileModuleRegistry.forEach(tileRegistrar);
        externalBlockRegistrars.add(blockRegistrar);
        blockModuleRegistry.forEach(blockRegistrar);
    }

    public static void forEachTileModule(BiConsumer<Class<? extends IModularTile>, Function<BlockEntity, TileModule<?>>> callback) {
        tileModuleRegistry.forEach(callback);
    }

    public static void forEachBlockModule(BiConsumer<Class<? extends IModularBlock>, Function<Block, BlockModule<?>>> callback) {
        blockModuleRegistry.forEach(callback);
    }
}

