/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.modular.tile;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.ChunkTicketLevelUpdatedEvent;
import net.roguelogix.phosphophyllite.modular.api.IModularTile;
import net.roguelogix.phosphophyllite.modular.api.ModuleRegistry;
import net.roguelogix.phosphophyllite.modular.api.TileModule;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.util.FastArraySet;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@NonnullDefault
public interface IIsTickingTracker {
    default public void startTicking() {
    }

    default public void stopTicking() {
    }

    public static final class Module
    extends TileModule<Tile> {
        private static final Object2ObjectMap<ServerLevel, LongSet> isTickingMap = new Object2ObjectOpenHashMap();
        private static final Object2ObjectMap<ServerLevel, Long2ObjectMap<ChunkTracker>> trackers = new Object2ObjectOpenHashMap();
        @Nullable
        ChunkTracker chunkTracker;
        @Nullable
        Long2ObjectMap<ChunkTracker> levelTrackers;
        @Nullable
        ServerLevel serverLevel;
        final ObjectArrayList<IIsTickingTracker> tileTrackers = new ObjectArrayList();

        @OnModLoad
        private static void onModLoad() {
            ModuleRegistry.registerTileModule(Tile.class, Module::new);
            MinecraftForge.EVENT_BUS.addListener(Module::ticketEventListener);
        }

        public Module(IModularTile iface) {
            super(iface);
        }

        @Override
        public void postModuleConstruction() {
            ((Tile)this.iface).modules().forEach(tileModule -> {
                if (tileModule instanceof IIsTickingTracker) {
                    IIsTickingTracker tracker = (IIsTickingTracker)((Object)tileModule);
                    this.tileTrackers.add((Object)tracker);
                }
            });
        }

        @Override
        public void onAdded() {
            BlockEntity tile = (BlockEntity)this.iface;
            Level level = tile.m_58904_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel;
                this.serverLevel = serverLevel = (ServerLevel)level;
                this.levelTrackers = (Long2ObjectMap)trackers.get((Object)serverLevel);
                if (this.levelTrackers == null) {
                    this.levelTrackers = new Long2ObjectOpenHashMap();
                    trackers.put((Object)serverLevel, this.levelTrackers);
                }
                this.chunkTracker = (ChunkTracker)this.levelTrackers.get(ChunkPos.m_151388_((BlockPos)tile.m_58899_()));
                if (this.chunkTracker == null) {
                    this.chunkTracker = new ChunkTracker();
                    LongSet tickingSet = (LongSet)isTickingMap.get((Object)serverLevel);
                    if (tickingSet == null) {
                        tickingSet = new LongOpenHashSet();
                        isTickingMap.put((Object)serverLevel, (Object)tickingSet);
                    }
                    this.chunkTracker.isTicking = tickingSet.contains(ChunkPos.m_151388_((BlockPos)tile.m_58899_()));
                    this.levelTrackers.put(ChunkPos.m_151388_((BlockPos)tile.m_58899_()), (Object)this.chunkTracker);
                }
                this.chunkTracker.modules.add(this);
                if (this.chunkTracker.isTicking) {
                    this.startTicking();
                }
            }
        }

        void startTicking() {
            this.tileTrackers.forEach(IIsTickingTracker::startTicking);
        }

        void stopTicking() {
            this.tileTrackers.forEach(IIsTickingTracker::stopTicking);
        }

        @Override
        public void onRemoved(boolean chunkUnload) {
            if (this.serverLevel == null || this.chunkTracker == null || this.levelTrackers == null) {
                return;
            }
            this.chunkTracker.modules.remove(this);
            if (this.chunkTracker.modules.size() == 0) {
                this.levelTrackers.remove(ChunkPos.m_151388_((BlockPos)((BlockEntity)this.iface).m_58899_()));
                if (this.levelTrackers.isEmpty()) {
                    trackers.remove((Object)this.serverLevel);
                }
            }
        }

        public static void ticketEventListener(ChunkTicketLevelUpdatedEvent ticketEvent) {
            ServerLevel level = ticketEvent.getLevel();
            LongSet isTickingSet = (LongSet)isTickingMap.get((Object)level);
            if (ticketEvent.getNewTicketLevel() <= 31) {
                if (isTickingSet == null) {
                    isTickingSet = new LongOpenHashSet();
                    isTickingMap.put((Object)level, (Object)isTickingSet);
                }
                if (isTickingSet.add(ticketEvent.getChunkPos())) {
                    Long2ObjectMap chunkTrackers = (Long2ObjectMap)trackers.get((Object)level);
                    if (chunkTrackers == null) {
                        return;
                    }
                    ChunkTracker tracker = (ChunkTracker)chunkTrackers.get(ticketEvent.getChunkPos());
                    if (tracker == null) {
                        return;
                    }
                    if (tracker.isTicking) {
                        return;
                    }
                    tracker.isTicking = true;
                    tracker.modules.elements().forEach(Module::startTicking);
                }
            } else {
                if (isTickingSet == null) {
                    return;
                }
                if (isTickingSet.remove(ticketEvent.getChunkPos())) {
                    Long2ObjectMap chunkTrackers = (Long2ObjectMap)trackers.get((Object)level);
                    if (chunkTrackers == null) {
                        return;
                    }
                    ChunkTracker tracker = (ChunkTracker)chunkTrackers.get(ticketEvent.getChunkPos());
                    if (tracker == null) {
                        return;
                    }
                    if (!tracker.isTicking) {
                        return;
                    }
                    tracker.isTicking = false;
                    tracker.modules.elements().forEach(Module::stopTicking);
                }
            }
        }

        private static final class ChunkTracker {
            boolean isTicking = false;
            final FastArraySet<Module> modules = new FastArraySet();

            private ChunkTracker() {
            }
        }
    }

    public static interface Tile
    extends IIsTickingTracker,
    IModularTile {
    }
}

