/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock.common;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.roguelogix.phosphophyllite.debug.DebugInfo;
import net.roguelogix.phosphophyllite.modular.api.IModularTile;
import net.roguelogix.phosphophyllite.multiblock.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock.common.IPersistentMultiblockTile;
import net.roguelogix.phosphophyllite.multiblock.modular.MultiblockControllerModule;
import net.roguelogix.phosphophyllite.multiblock.modular.MultiblockControllerModuleRegistry;
import net.roguelogix.phosphophyllite.multiblock.validated.IValidatedMultiblock;
import net.roguelogix.phosphophyllite.multiblock.validated.IValidatedMultiblockControllerModule;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.phosphophyllite.util.Util;

@NonnullDefault
public interface IPersistentMultiblock<TileType extends BlockEntity, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType>>
extends IValidatedMultiblock<TileType, BlockType, ControllerType> {
    public CompoundTag mergeNBTs(CompoundTag var1, CompoundTag var2);

    public void read(CompoundTag var1);

    @Nullable
    public CompoundTag write();

    default public Module<TileType, BlockType, ControllerType> persistentModule() {
        return this.module(IPersistentMultiblock.class, Module.class);
    }

    default public void dirty() {
        Module module = this.module(IPersistentMultiblock.class, Module.class);
        if (!1.$assertionsDisabled && module == null) {
            throw new AssertionError();
        }
        module.dirty();
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static final class Module<TileType extends BlockEntity, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType>>
    extends MultiblockControllerModule<TileType, BlockType, ControllerType>
    implements IValidatedMultiblockControllerModule {
        @Nullable
        private TileType saveDelegate;
        private boolean hasSaveDelegate = false;
        @Nullable
        private IPersistentMultiblockTile.Module<TileType, BlockType, ControllerType> saveDelegateModule;
        @Nullable
        private CompoundTag nbt;
        private boolean shouldReadNBT = false;
        private int expectedBlocks = 0;
        @Nullable
        private IValidatedMultiblock.AssemblyState lastAssemblyState;

        @OnModLoad
        public static void register() {
            MultiblockControllerModuleRegistry.registerModule(IPersistentMultiblock.class, Module::new);
        }

        public Module(IPersistentMultiblock<TileType, BlockType, ControllerType> controller) {
            super(controller);
        }

        private void partAdded(TileType newPart) {
            IPersistentMultiblockTile.Module persistentModule = ((IModularTile)newPart).module(IPersistentMultiblockTile.class, IPersistentMultiblockTile.Module.class);
            assert (persistentModule != null);
            if (this.expectedBlocks == 0) {
                this.expectedBlocks = persistentModule.expectedBlocks;
            }
            if (persistentModule.expectedBlocks != 0 && persistentModule.expectedBlocks != this.expectedBlocks) {
                this.expectedBlocks = 0;
            }
            if (this.lastAssemblyState == null) {
                this.lastAssemblyState = persistentModule.lastAssemblyState;
            }
            CompoundTag newNBT = persistentModule.controllerNBT;
            persistentModule.controllerNBT = null;
            if (newNBT == null) {
                return;
            }
            if (this.saveDelegate == null) {
                this.saveDelegate = newPart;
                this.saveDelegateModule = persistentModule;
            }
            if (this.nbt != null) {
                if (this.nbt.equals((Object)newNBT)) {
                    return;
                }
                this.nbt = ((IPersistentMultiblock)((Object)this.controller)).mergeNBTs(this.nbt, newNBT);
            } else {
                this.nbt = newNBT;
            }
            this.shouldReadNBT = true;
        }

        private void partRemoved(TileType oldPart) {
            if (oldPart == this.saveDelegate) {
                this.saveDelegate = null;
                this.saveDelegateModule = null;
            }
        }

        @Override
        public void merge(ControllerType other) {
            Module otherPersistentModule = other.module(IPersistentMultiblock.class, Module.class);
            assert (otherPersistentModule != null);
            if (otherPersistentModule.nbt != null) {
                if (((IValidatedMultiblock)((Object)this.controller)).assemblyState() != IValidatedMultiblock.AssemblyState.DISASSEMBLED) {
                    return;
                }
                if (this.nbt == null) {
                    this.nbt = otherPersistentModule.nbt;
                    this.shouldReadNBT = true;
                    return;
                }
                this.nbt = ((IPersistentMultiblock)((Object)this.controller)).mergeNBTs(this.nbt, otherPersistentModule.nbt);
                this.shouldReadNBT = true;
            }
        }

        @Override
        public void onPartLoaded(TileType tile) {
            this.partAdded(tile);
        }

        @Override
        public void onPartUnloaded(TileType tile) {
            this.partRemoved(tile);
        }

        @Override
        public void onPartAttached(TileType tile) {
            this.partAdded(tile);
        }

        @Override
        public void onPartDetached(TileType tile) {
            this.partRemoved(tile);
        }

        @Override
        public void onPartPlaced(TileType tile) {
            this.expectedBlocks = 0;
        }

        @Override
        public void onPartBroken(TileType tile) {
            this.expectedBlocks = 0;
            this.partRemoved(tile);
            if (tile == this.saveDelegate) {
                this.hasSaveDelegate = false;
            }
        }

        private void pickDelegate() {
            if (this.hasSaveDelegate) {
                return;
            }
            this.saveDelegate = this.controller.randomTile();
            this.saveDelegateModule = ((IModularTile)this.saveDelegate).module(IPersistentMultiblockTile.class, IPersistentMultiblockTile.Module.class);
            if (this.saveDelegateModule != null) {
                this.saveDelegateModule.controllerNBT = null;
            }
            this.hasSaveDelegate = true;
        }

        @Override
        public boolean canValidate() {
            return this.expectedBlocks <= this.controller.blocks.size();
        }

        @Override
        public boolean canTick() {
            return this.canValidate();
        }

        @Override
        public void onStateTransition(IValidatedMultiblock.AssemblyState oldAssemblyState, IValidatedMultiblock.AssemblyState newAssemblyState) {
            if (this.shouldReadNBT) {
                this.shouldReadNBT = false;
                if (this.nbt != null) {
                    ((IPersistentMultiblock)((Object)this.controller)).read(this.nbt);
                }
            }
        }

        void dirty() {
            this.pickDelegate();
            this.nbt = null;
            if (this.saveDelegateModule != null) {
                this.saveDelegateModule.controllerNBT = null;
            }
            Util.markRangeDirty(this.controller.level, this.controller.min(), this.controller.max());
        }

        boolean isSaveDelegate(TileType tile) {
            this.pickDelegate();
            return tile == this.saveDelegate;
        }

        @Nullable
        CompoundTag getNBT() {
            if (this.nbt == null) {
                this.nbt = ((IPersistentMultiblock)((Object)this.controller)).write();
            }
            return this.nbt;
        }

        @Override
        @Nullable
        public DebugInfo getDebugInfo() {
            DebugInfo debugInfo = new DebugInfo("PersistentMultiblock");
            return null;
        }
    }
}

