/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock.common;

import javax.annotation.Nonnull;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.roguelogix.phosphophyllite.multiblock.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock.modular.IModularMultiblockController;
import net.roguelogix.phosphophyllite.multiblock.modular.MultiblockControllerModule;
import net.roguelogix.phosphophyllite.multiblock.modular.MultiblockControllerModuleRegistry;
import net.roguelogix.phosphophyllite.multiblock.validated.IAssembledTickMultiblockModule;
import net.roguelogix.phosphophyllite.multiblock.validated.IValidatedMultiblock;
import net.roguelogix.phosphophyllite.multiblock.validated.IValidatedMultiblockTile;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.util.FastArraySet;
import net.roguelogix.phosphophyllite.util.NonnullDefault;

@NonnullDefault
public interface ITickablePartsMultiblock<TileType extends BlockEntity & IValidatedMultiblockTile<TileType, BlockType, ControllerType>, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType> & IValidatedMultiblock<TileType, BlockType, ControllerType>>
extends IModularMultiblockController<TileType, BlockType, ControllerType> {

    public static final class Module<TileType extends BlockEntity & IValidatedMultiblockTile<TileType, BlockType, ControllerType>, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType> & IValidatedMultiblock<TileType, BlockType, ControllerType>>
    extends MultiblockControllerModule<TileType, BlockType, ControllerType>
    implements IAssembledTickMultiblockModule {
        private final FastArraySet<Tickable> tickables = new FastArraySet();

        @OnModLoad
        public static void register() {
            MultiblockControllerModuleRegistry.registerModule(ITickablePartsMultiblock.class, Module::new);
        }

        public Module(IModularMultiblockController<TileType, BlockType, ControllerType> controller) {
            super(controller);
        }

        @Override
        public void onPartAdded(@Nonnull TileType tile) {
            if (tile instanceof Tickable) {
                Tickable tickable = (Tickable)tile;
                this.tickables.add(tickable);
            }
        }

        @Override
        public void onPartRemoved(@Nonnull TileType tile) {
            if (tile instanceof Tickable) {
                Tickable tickable = (Tickable)tile;
                this.tickables.remove(tickable);
            }
        }

        @Override
        public void preTick() {
            this.tickables.elements().forEach(Tickable::preTick);
        }

        @Override
        public void postTick() {
            this.tickables.elements().forEach(Tickable::postTick);
        }
    }

    public static interface Tickable {
        public void preTick();

        public void postTick();
    }
}

