/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.multiblock.touching;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.roguelogix.phosphophyllite.modular.api.IModularTile;
import net.roguelogix.phosphophyllite.modular.api.ModuleRegistry;
import net.roguelogix.phosphophyllite.modular.api.TileModule;
import net.roguelogix.phosphophyllite.multiblock.IMultiblockTile;
import net.roguelogix.phosphophyllite.multiblock.MultiblockController;
import net.roguelogix.phosphophyllite.multiblock.modular.ICoreMultiblockTileModule;
import net.roguelogix.phosphophyllite.multiblock.rectangular.IRectangularMultiblock;
import net.roguelogix.phosphophyllite.multiblock.rectangular.IRectangularMultiblockTile;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.phosphophyllite.util.VectorUtil;
import org.joml.Vector3i;
import org.joml.Vector3ic;

@NonnullDefault
public interface ITouchingMultiblockTile<TileType extends BlockEntity & IRectangularMultiblockTile<TileType, BlockType, ControllerType>, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType> & IRectangularMultiblock<TileType, BlockType, ControllerType>>
extends IMultiblockTile<TileType, BlockType, ControllerType> {

    public static final class Module<TileType extends BlockEntity & IRectangularMultiblockTile<TileType, BlockType, ControllerType>, BlockType extends Block, ControllerType extends MultiblockController<TileType, BlockType, ControllerType> & IRectangularMultiblock<TileType, BlockType, ControllerType>>
    extends TileModule<TileType>
    implements ICoreMultiblockTileModule<TileType, BlockType, ControllerType> {
        boolean assembled = false;
        final Vector3i min = new Vector3i();
        final Vector3i max = new Vector3i();

        @OnModLoad
        public static void register() {
            ModuleRegistry.registerTileModule(ITouchingMultiblockTile.class, Module::new);
        }

        public Module(IModularTile iface) {
            super(iface);
        }

        @Override
        public boolean shouldConnectTo(TileType tile, Direction direction) {
            if (!this.assembled) {
                return true;
            }
            return VectorUtil.lequal((Vector3ic)this.min, tile.m_58899_()) && VectorUtil.grequal((Vector3ic)this.max, tile.m_58899_());
        }

        @Override
        public String saveKey() {
            return "touching_multiblock";
        }

        @Override
        public void readNBT(CompoundTag nbt) {
            this.assembled = nbt.m_128471_("assembled");
            this.min.set(nbt.m_128451_("minx"), nbt.m_128451_("miny"), nbt.m_128451_("minz"));
            this.max.set(nbt.m_128451_("maxx"), nbt.m_128451_("maxy"), nbt.m_128451_("maxz"));
        }

        @Override
        public CompoundTag writeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("assembled", this.assembled);
            tag.m_128405_("minx", this.min.x());
            tag.m_128405_("miny", this.min.y());
            tag.m_128405_("minz", this.min.z());
            tag.m_128405_("maxx", this.max.x());
            tag.m_128405_("maxy", this.max.y());
            tag.m_128405_("maxz", this.max.z());
            return tag;
        }
    }
}

