/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.util;

import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AStarList<TileType> {
    TreeSet<TileType> targets = new TreeSet(this::orderingFunction);
    TreeSet<TileType> nodeSet = new TreeSet(this::orderingFunction);
    final Function<TileType, BlockPos> posFunc;

    public AStarList(Function<TileType, BlockPos> posFunc) {
        this.posFunc = posFunc;
    }

    private int orderingFunction(TileType a, TileType b) {
        double bDistance;
        if (this.targets.isEmpty()) {
            return 0;
        }
        BlockPos aPos = this.posFunc.apply(a);
        BlockPos bPos = this.posFunc.apply(b);
        BlockPos target = this.posFunc.apply(this.targets.first());
        double aDistance = aPos.m_123331_((Vec3i)target);
        return aDistance < (bDistance = bPos.m_123331_((Vec3i)target)) ? -1 : (bDistance == aDistance ? Integer.compare(a.hashCode(), b.hashCode()) : 1);
    }

    public void addTarget(TileType target) {
        if (this.nodeSet.isEmpty()) {
            this.nodeSet.add(target);
        } else {
            this.targets.add(target);
        }
    }

    public void addNode(TileType node) {
        this.targets.remove(node);
        this.nodeSet.add(node);
    }

    public TileType nextNode() {
        return Objects.requireNonNull(this.nodeSet.pollFirst());
    }

    public boolean done() {
        return this.targets.isEmpty() || this.nodeSet.isEmpty();
    }

    public boolean foundAll() {
        return this.targets.isEmpty();
    }
}

